/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.dialog;

import java.util.HashMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import scouter.client.model.XLogData;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ExUtil;
import scouter.client.xlog.dialog.XLogSummaryAbstractDialog;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;
import scouter.util.TopN;

public class XLogSummaryUserDialog
extends XLogSummaryAbstractDialog {
    public XLogSummaryUserDialog(Display display, LongKeyLinkedMap<XLogData> dataMap) {
        super(display, dataMap);
    }

    @Override
    protected void calcAsync() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                HashMap<Long, UserSummary> summaryMap = new HashMap<Long, UserSummary>();
                LongEnumer longEnumer = XLogSummaryUserDialog.this.dataMap.keys();
                while (longEnumer.hasMoreElements()) {
                    XLogData d = (XLogData)XLogSummaryUserDialog.this.dataMap.get(longEnumer.nextLong());
                    long time = d.p.endTime;
                    if (!d.filter_ok || time < XLogSummaryUserDialog.this.stime || time > XLogSummaryUserDialog.this.etime || ObjectSelectManager.getInstance().isUnselectedObject(d.p.objHash)) continue;
                    UserSummary summary = (UserSummary)summaryMap.get(d.p.userid);
                    if (summary == null) {
                        summary = new UserSummary();
                        summary.id = d.p.userid;
                        summaryMap.put(d.p.userid, summary);
                    }
                    summary.count = summary.count + 1;
                    summary.sumTime += (long)d.p.elapsed;
                    if ((long)d.p.elapsed > summary.maxTime) {
                        summary.maxTime = d.p.elapsed;
                    }
                    if (d.p.error != 0) {
                        summary.error = summary.error + 1;
                    }
                    summary.cpu += (long)d.p.cpu;
                    summary.memory += (long)d.p.kbytes;
                    summary.sqltime += (long)d.p.sqlTime;
                    summary.apicalltime += (long)d.p.apicallTime;
                }
                final TopN stn = new TopN(10000, TopN.DIRECTION.DESC);
                for (UserSummary so : summaryMap.values()) {
                    stn.add((Comparable)so);
                }
                ExUtil.exec((Composite)XLogSummaryUserDialog.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        (this).XLogSummaryUserDialog.this.rangeLabel.setText(String.valueOf(DateUtil.format((long)(this).XLogSummaryUserDialog.this.stime, (String)"yyyy-MM-dd HH:mm:ss")) + " ~ " + DateUtil.format((long)(this).XLogSummaryUserDialog.this.etime, (String)"HH:mm:ss") + " (" + stn.size() + ")");
                        (this).XLogSummaryUserDialog.this.viewer.setInput((Object)stn.getList());
                    }
                });
            }
        });
    }

    @Override
    public String getTitle() {
        return "User Summary";
    }

    @Override
    protected void createMainColumn() {
        TableViewerColumn c = this.createTableViewerColumn("User ID", 100, 16384, true);
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof UserSummary) {
                    return CastUtil.cString((Object)((UserSummary)element).id);
                }
                return null;
            }
        };
        c.setLabelProvider((CellLabelProvider)labelProvider);
    }

    private static class UserSummary
    extends XLogSummaryAbstractDialog.SummaryObject
    implements Comparable<UserSummary> {
        long id;

        private UserSummary() {
        }

        @Override
        public int compareTo(UserSummary o) {
            return this.count - o.count;
        }
    }
}

