/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.popup.SQLFormatDialog;
import scouter.client.util.UIUtil;
import scouter.lang.step.HashedMessageStep;
import scouter.lang.step.SqlStep;
import scouter.lang.step.SqlStep3;
import scouter.lang.step.Step;
import scouter.lang.step.StepSingle;
import scouter.util.FormatUtil;
import scouter.util.Hexa32;

public class XlogSummarySQLDialog
extends Dialog {
    private Table sqlTable;
    private Table bindTable;
    private Step[] steps;
    private XLogData xperf;
    private HashMap<Integer, SQLSumData> sqlMap = new HashMap();

    public XlogSummarySQLDialog(Shell shell, Step[] steps, XLogData xperf) {
        super(shell);
        this.xperf = xperf;
        this.steps = steps;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        FillLayout layout = new FillLayout();
        container.setLayout((Layout)layout);
        SashForm sashVertForm = new SashForm(container, 512);
        sashVertForm.SASH_WIDTH = 3;
        this.initSQLTable((Composite)sashVertForm);
        this.initBindTable((Composite)sashVertForm);
        sashVertForm.setWeights(new int[]{55, 45});
        this.processSqlData();
        this.displaySQLSumData();
        return container;
    }

    private void initSQLTable(Composite parent) {
        this.sqlTable = new Table(parent, 67584);
        TableColumn tableColumn = new TableColumn(this.sqlTable, 131072);
        tableColumn.setText("Execs");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.sqlTable, 131072);
        tableColumn.setText("Binds");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.sqlTable, 131072);
        tableColumn.setText("Exec Time");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.sqlTable, 131072);
        tableColumn.setText("Fetch Time");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.sqlTable, 131072);
        tableColumn.setText("Total Rows");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.sqlTable, 16384);
        tableColumn.setText("SQL Text");
        tableColumn.setWidth(600);
        this.sqlTable.setHeaderVisible(true);
        this.sqlTable.setVisible(true);
        this.sqlTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                XlogSummarySQLDialog.this.bindTable.clearAll();
                XlogSummarySQLDialog.this.bindTable.setItemCount(0);
                TableItem item = (TableItem)event.item;
                if (item == null) {
                    return;
                }
                Integer hash = (Integer)item.getData();
                ArrayList<BindSumData> list = XlogSummarySQLDialog.this.getLBindSumDataList(hash);
                Collections.sort(list, new BindSumDataComp());
                String sqlText = XlogSummarySQLDialog.this.sqlMap.get((Object)hash).sqlText;
                if (sqlText != null) {
                    sqlText = sqlText.replaceAll("(\r\n|\r|\n|\n\r)", " ");
                }
                for (BindSumData value : list) {
                    TableItem bindItem = new TableItem(XlogSummarySQLDialog.this.bindTable, 2048);
                    bindItem.setText(value.toTableInfo());
                    bindItem.setData((Object)sqlText);
                }
            }
        });
    }

    private void initBindTable(Composite parent) {
        this.bindTable = new Table(parent, 67584);
        TableColumn tableColumn = new TableColumn(this.bindTable, 131072);
        tableColumn.setText("Execs");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.bindTable, 131072);
        tableColumn.setText("Exec Time");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.bindTable, 131072);
        tableColumn.setText("Fetch Time");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.bindTable, 131072);
        tableColumn.setText("Total Rows");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.bindTable, 16384);
        tableColumn.setText("Bind Variables");
        tableColumn.setWidth(600);
        this.bindTable.setHeaderVisible(true);
        this.bindTable.setVisible(true);
        this.bindTable.setToolTipText("Please double click on in order to view the complete SQL statement");
        this.bindTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent event) {
                TableItem[] items = XlogSummarySQLDialog.this.bindTable.getSelection();
                if (items.length == 0) {
                    return;
                }
                TableItem item = items[0];
                String sqlText = (String)item.getData();
                String binds = item.getText(4);
                new SQLFormatDialog().show(sqlText, null, binds);
            }

            public void mouseDown(MouseEvent event) {
            }

            public void mouseUp(MouseEvent event) {
            }
        });
    }

    protected void displaySQLSumData() {
        this.sqlTable.clearAll();
        this.sqlTable.setItemCount(0);
        ArrayList<SQLSumData> list = this.getLSQLSumDataList();
        Collections.sort(list, new SQLSumDataComp());
        for (SQLSumData value : list) {
            TableItem item = new TableItem(this.sqlTable, 2048);
            item.setText(value.toTableInfo());
            item.setData((Object)new Integer(value.hash));
        }
    }

    protected void processSqlData() {
        SQLSumData sqlSumData = null;
        BindSumData bindSumData = null;
        int i = 0;
        while (i < this.steps.length) {
            StepSingle stepSingle = (StepSingle)this.steps[i];
            switch (stepSingle.getStepType()) {
                case 2: 
                case 8: 
                case 16: {
                    int updatedCount;
                    SqlStep sql = (SqlStep)stepSingle;
                    sqlSumData = this.sqlMap.get(sql.hash);
                    if (sqlSumData == null) {
                        sqlSumData = new SQLSumData();
                        sqlSumData.hash = sql.hash;
                        sqlSumData.sqlText = TextProxy.sql.getText(sql.hash);
                        if (sqlSumData.sqlText != null) {
                            sqlSumData.sqlText = sqlSumData.sqlText.replaceAll("(\r\n|\r|\n|\n\r)", " ");
                        }
                        this.sqlMap.put(sql.hash, sqlSumData);
                    }
                    ++sqlSumData.execs;
                    sqlSumData.execTime += sql.elapsed;
                    bindSumData = sqlSumData.bindMap.get(sql.param);
                    if (bindSumData == null) {
                        ++sqlSumData.binds;
                        bindSumData = new BindSumData();
                        String bindParam = sql.param == null ? "[No Value]" : sql.param;
                        bindSumData.bindText = bindParam;
                        sqlSumData.bindMap.put(bindParam, bindSumData);
                    }
                    ++bindSumData.execs;
                    bindSumData.execTime += sql.elapsed;
                    if (16 != stepSingle.getStepType() || (updatedCount = ((SqlStep3)stepSingle).updated) <= -1) break;
                    sqlSumData.totalRows += updatedCount;
                    bindSumData.totalRows += updatedCount;
                    break;
                }
                case 9: {
                    HashedMessageStep message = (HashedMessageStep)stepSingle;
                    if (!"RESULT-SET-FETCH".equals(TextProxy.hashMessage.getText(message.hash))) break;
                    if (sqlSumData != null) {
                        sqlSumData.fetchTime += message.time;
                        sqlSumData.totalRows += message.value;
                    }
                    if (bindSumData == null) break;
                    bindSumData.fetchTime += message.time;
                    bindSumData.totalRows += message.value;
                }
            }
            ++i;
        }
    }

    private ArrayList<SQLSumData> getLSQLSumDataList() {
        ArrayList<SQLSumData> list = new ArrayList<SQLSumData>();
        Iterator<SQLSumData> itor = this.sqlMap.values().iterator();
        while (itor.hasNext()) {
            list.add(itor.next());
        }
        return list;
    }

    private ArrayList<BindSumData> getLBindSumDataList(int hash) {
        ArrayList<BindSumData> list = new ArrayList<BindSumData>();
        SQLSumData sqlSumData = this.sqlMap.get(hash);
        if (sqlSumData == null) {
            return null;
        }
        HashMap<String, BindSumData> bindMap = sqlSumData.bindMap;
        Iterator<BindSumData> itor = bindMap.values().iterator();
        while (itor.hasNext()) {
            list.add(itor.next());
        }
        return list;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(new StringBuilder(100).append("SQL Statistics Summary-").append(TextProxy.service.getText(this.xperf.p.service)).append('(').append(Hexa32.toString32((long)this.xperf.p.txid)).append(")-").append(FormatUtil.print((Object)this.xperf.p.elapsed, (String)"#,##0")).append("ms").toString());
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected void initializeBounds() {
        int[] size = UIUtil.getScreenSize();
        this.getShell().setBounds(size[0] / 2 - 400, size[1] / 2 - 200, 800, 400);
    }

    private class BindSumData {
        public int execs = 0;
        public int execTime = 0;
        public int fetchTime = 0;
        public int totalRows = 0;
        public String bindText = null;

        private BindSumData() {
        }

        public String[] toTableInfo() {
            String[] values = new String[6];
            values[0] = FormatUtil.print((Object)this.execs, (String)"#,##0");
            values[1] = FormatUtil.print((Object)this.execTime, (String)"#,##0");
            values[2] = FormatUtil.print((Object)this.fetchTime, (String)"#,##0");
            values[3] = FormatUtil.print((Object)this.totalRows, (String)"#,##0");
            values[4] = this.bindText;
            return values;
        }
    }

    private class BindSumDataComp
    implements Comparator<BindSumData> {
        private BindSumDataComp() {
        }

        @Override
        public int compare(BindSumData o1, BindSumData o2) {
            if (o1.execTime > o2.execTime) {
                return -1;
            }
            if (o1.execTime < o2.execTime) {
                return 1;
            }
            return 0;
        }
    }

    private class SQLSumData {
        public int execs = 0;
        public int binds = 0;
        public int execTime = 0;
        public int fetchTime = 0;
        public int totalRows = 0;
        public String sqlText = null;
        public int hash = 0;
        public HashMap<String, BindSumData> bindMap = new HashMap();

        private SQLSumData() {
        }

        public String[] toTableInfo() {
            String[] values = new String[]{FormatUtil.print((Object)this.execs, (String)"#,##0"), FormatUtil.print((Object)this.binds, (String)"#,##0"), FormatUtil.print((Object)this.execTime, (String)"#,##0"), FormatUtil.print((Object)this.fetchTime, (String)"#,##0"), FormatUtil.print((Object)this.totalRows, (String)"#,##0"), this.sqlText};
            return values;
        }
    }

    private class SQLSumDataComp
    implements Comparator<SQLSumData> {
        private SQLSumDataComp() {
        }

        @Override
        public int compare(SQLSumData o1, SQLSumData o2) {
            if (o1.execTime > o2.execTime) {
                return -1;
            }
            if (o1.execTime < o2.execTime) {
                return 1;
            }
            return 0;
        }
    }
}

