/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.zest.core.viewers.IGraphContentProvider;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import scouter.client.Images;
import scouter.client.model.AgentDailyListProxy;
import scouter.client.model.AgentObject;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.xlog.XLogUtil;
import scouter.client.xlog.actions.OpenXLogProfileJob;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.Hexa32;
import scouter.util.IPUtil;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;
import scouter.util.LongKeyMap;

public class XLogCallView
extends ViewPart {
    public static final String ID = XLogCallView.class.getName();
    private GraphViewer viewer = null;
    private String date;
    private long gxid;
    private XLogData xlogData;
    AgentDailyListProxy agentProxy = new AgentDailyListProxy();

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        parent.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                XLogCallView.this.viewer.applyLayout();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.viewer = new GraphViewer(parent, 0);
        this.viewer.setContentProvider((IContentProvider)new XLogFlowContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new XLogFlowLabelProvider());
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                if (sel.getFirstElement() instanceof XLogConnection) {
                    XLogData d = ((XLogConnection)sel.getFirstElement()).destXlog;
                    String date = DateUtil.yyyymmdd((long)d.p.endTime);
                    ArrayList<AgentObject> objList = XLogCallView.this.agentProxy.getObjectList(date, d.serverId);
                    for (AgentObject obj : objList) {
                        if (obj.getObjHash() != d.p.objHash) continue;
                        new OpenXLogProfileJob(XLogCallView.this.getViewSite().getShell().getDisplay(), d, d.serverId).schedule();
                        break;
                    }
                }
            }
        });
    }

    public void searchByGxId(String date, long gxId) {
        this.date = date;
        this.gxid = gxId;
        this.setPartName("GxID - " + Hexa32.toString32((long)gxId));
        this.loadByGxId();
    }

    public void searchByTxId(XLogData d) {
        this.date = DateUtil.yyyymmdd((long)d.p.endTime);
        this.xlogData = d;
        this.loadByTxId();
    }

    public void setFocus() {
    }

    private void loadByGxId() {
        new LoadGlobalXLog().schedule();
    }

    private void loadByTxId() {
        new LoadChainXLog().schedule();
    }

    class LoadChainXLog
    extends Job {
        public LoadChainXLog() {
            super("Load " + XLogCallView.this.date);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Find " + Hexa32.toString32((long)XLogCallView.this.xlogData.p.txid), -1);
            final LongKeyLinkedMap xlogMap = new LongKeyLinkedMap();
            xlogMap.put(XLogCallView.this.xlogData.p.txid, (Object)XLogCallView.this.xlogData);
            long callerId = XLogCallView.this.xlogData.p.caller;
            boolean found = true;
            block5: while (found && callerId != 0L) {
                found = false;
                for (int serverId : ServerManager.getInstance().getOpenServerList()) {
                    monitor.subTask(ServerManager.getInstance().getServer(serverId).getName());
                    TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
                    try {
                        MapPack param = new MapPack();
                        param.put("date", XLogCallView.this.date);
                        param.put("txid", callerId);
                        Pack p = tcp.getSingle("XLOG_READ_BY_TXID", (Pack)param);
                        if (p == null) continue;
                        XLogPack xlog = XLogUtil.toXLogPack(p);
                        XLogData d = new XLogData(xlog, serverId);
                        d.objName = TextProxy.object.getLoadText(XLogCallView.this.date, d.p.objHash, serverId);
                        xlogMap.put(xlog.txid, (Object)d);
                        callerId = xlog.caller;
                        found = true;
                        continue block5;
                    }
                    catch (Throwable th) {
                        ConsoleProxy.errorSafe(th.toString());
                        callerId = 0L;
                    }
                    finally {
                        TcpProxy.putTcpProxy(tcp);
                    }
                }
            }
            ExUtil.exec((Composite)XLogCallView.this.viewer.getGraphControl(), new Runnable(){

                @Override
                public void run() {
                    ((LoadChainXLog)LoadChainXLog.this).XLogCallView.this.viewer.setInput((Object)xlogMap);
                }
            });
            return Status.OK_STATUS;
        }
    }

    class LoadGlobalXLog
    extends Job {
        public LoadGlobalXLog() {
            super("Load " + XLogCallView.this.date);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Find " + Hexa32.toString32((long)XLogCallView.this.gxid), -1);
            final LongKeyLinkedMap xlogMap = new LongKeyLinkedMap();
            for (final int serverId : ServerManager.getInstance().getOpenServerList()) {
                monitor.subTask(ServerManager.getInstance().getServer(serverId).getName());
                TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
                try {
                    try {
                        MapPack param = new MapPack();
                        param.put("date", XLogCallView.this.date);
                        param.put("gxid", XLogCallView.this.gxid);
                        tcp.process("XLOG_READ_BY_GXID", param, new INetReader(){

                            @Override
                            public void process(DataInputX in) throws IOException {
                                Pack p = in.readPack();
                                XLogPack xlog = XLogUtil.toXLogPack(p);
                                XLogData d = new XLogData(xlog, serverId);
                                d.objName = TextProxy.object.getLoadText(((LoadGlobalXLog)LoadGlobalXLog.this).XLogCallView.this.date, d.p.objHash, d.serverId);
                                xlogMap.putFirst(xlog.txid, (Object)d);
                            }
                        });
                    }
                    catch (Throwable th) {
                        ConsoleProxy.errorSafe(th.toString());
                        TcpProxy.putTcpProxy(tcp);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
            ExUtil.exec((Composite)XLogCallView.this.viewer.getGraphControl(), new Runnable(){

                @Override
                public void run() {
                    ((LoadGlobalXLog)LoadGlobalXLog.this).XLogCallView.this.viewer.setInput((Object)xlogMap);
                }
            });
            return Status.OK_STATUS;
        }
    }

    static class StartHome {
        String ip;

        StartHome(String ip) {
            this.ip = ip;
        }
    }

    static class XLogConnection {
        long sourceId;
        XLogData destXlog;
        String name;
        long elapsed;
        boolean error = false;

        XLogConnection(long srcId, XLogData destXlog) {
            this.sourceId = srcId;
            this.destXlog = destXlog;
        }
    }

    class XLogFlowContentProvider
    implements IGraphContentProvider {
        LongKeyLinkedMap<XLogData> xlogMap;

        XLogFlowContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                this.xlogMap = (LongKeyLinkedMap)newInput;
            }
        }

        public Object getSource(Object obj) {
            if (obj instanceof XLogConnection) {
                long key = ((XLogConnection)obj).sourceId;
                if (key == 0L) {
                    XLogData d = ((XLogConnection)obj).destXlog;
                    return new StartHome(IPUtil.toString((byte[])d.p.ipaddr));
                }
                return this.xlogMap.get(key);
            }
            return null;
        }

        public Object getDestination(Object obj) {
            if (obj instanceof XLogConnection) {
                return ((XLogConnection)obj).destXlog;
            }
            return null;
        }

        public Object[] getElements(Object input) {
            LongEnumer keys = this.xlogMap.keys();
            ArrayList<XLogConnection> list = new ArrayList<XLogConnection>();
            LongKeyMap countMap = new LongKeyMap();
            while (keys.hasMoreElements()) {
                long key = keys.nextLong();
                XLogData d = (XLogData)this.xlogMap.get(key);
                long caller = d.p.caller;
                Integer cntInt = (Integer)countMap.get(caller);
                if (cntInt == null) {
                    cntInt = new Integer(1);
                    countMap.put(caller, (Object)cntInt);
                } else {
                    cntInt = new Integer(cntInt + 1);
                    countMap.put(caller, (Object)cntInt);
                }
                XLogConnection conn = new XLogConnection(caller, d);
                String serviceName = TextProxy.service.getLoadText(DateUtil.yyyymmdd((long)d.p.endTime), d.p.service, d.serverId);
                conn.name = "(" + cntInt + ") " + serviceName.substring(serviceName.lastIndexOf("/"), serviceName.length());
                conn.elapsed = d.p.elapsed;
                conn.error = d.p.error != 0;
                list.add(conn);
            }
            return list.toArray();
        }
    }

    class XLogFlowLabelProvider
    implements ILabelProvider,
    IConnectionStyleProvider {
        XLogFlowLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public int getConnectionStyle(Object rel) {
            return 2;
        }

        public Color getColor(Object rel) {
            if (rel instanceof XLogConnection) {
                XLogConnection conn = (XLogConnection)rel;
                if (conn.error || conn.elapsed > 8000L) {
                    return ColorUtil.getInstance().getColor(4);
                }
            }
            return ColorUtil.getInstance().getColor(16);
        }

        public Color getHighlightColor(Object rel) {
            return null;
        }

        public int getLineWidth(Object rel) {
            return 0;
        }

        public IFigure getTooltip(Object entity) {
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof StartHome) {
                return Images.CONFIG_USER;
            }
            if (element instanceof XLogData) {
                XLogData d = (XLogData)element;
                AgentObject ao = XLogCallView.this.agentProxy.getAgentObject(DateUtil.yyyymmdd((long)d.p.endTime), d.serverId, d.p.objHash);
                if (ao != null) {
                    return Images.getObjectIcon(ao.getObjType(), true, ao.getServerId());
                }
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof XLogData) {
                XLogData d = (XLogData)element;
                return d.objName;
            }
            if (element instanceof XLogConnection) {
                XLogConnection conn = (XLogConnection)element;
                return String.valueOf(conn.name) + "(" + FormatUtil.print((Object)conn.elapsed, (String)"#,###") + " ms)";
            }
            if (element instanceof StartHome) {
                return ((StartHome)element).ip;
            }
            return null;
        }
    }
}

