/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import java.io.Serializable;

public enum XLogColumnEnum implements Serializable
{
    OBJECT("Object", 80, 16384, true, true, false, true, "XLOG_COL_OBJECT"),
    ELAPSED("Elapsed", 50, 131072, true, true, true, true, "XLOG_COL_ELAPSED"),
    SERVICE("Service", 100, 16384, true, true, false, true, "XLOG_COL_SERVICE"),
    END_TIME("EndTime", 70, 0x1000000, true, true, true, true, "XLOG_COL_END_TIME"),
    CPU("Cpu", 40, 131072, true, true, true, true, "XLOG_COL_CPU"),
    SQL_COUNT("SQL Count", 50, 131072, true, true, true, true, "XLOG_COL_SQL_COUNT"),
    SQL_TIME("SQL Time", 50, 131072, true, true, true, true, "XLOG_COL_SQL_TIME"),
    API_COUNT("API Count", 50, 131072, true, true, true, true, "XLOG_COL_SQL_COUNT"),
    API_TIME("API Time", 50, 131072, true, true, true, true, "XLOG_COL_SQL_TIME"),
    KBYTES("KBytes", 60, 131072, true, true, true, true, "XLOG_COL_KBYTES"),
    IP("IP", 90, 16384, true, true, false, true, "XLOG_COL_IP"),
    LOGIN("Login", 50, 16384, true, true, false, true, "XLOG_COL_LOGIN"),
    DESC("Desc", 50, 16384, true, true, false, true, "XLOG_COL_DESC"),
    TEXT1("Text1", 50, 16384, true, true, false, true, "XLOG_COL_TEXT1"),
    TEXT2("Text2", 50, 16384, true, true, false, true, "XLOG_COL_TEXT2"),
    TEXT3("Text3", 50, 16384, true, true, false, false, "XLOG_COL_TEXT3"),
    TEXT4("Text4", 50, 16384, true, true, false, false, "XLOG_COL_TEXT4"),
    TEXT5("Text5", 50, 16384, true, true, false, false, "XLOG_COL_TEXT5"),
    ERROR("Error", 50, 16384, true, true, false, true, "XLOG_COL_ERROR"),
    DUMP("Dump", 40, 0x1000000, true, true, false, true, "XLOG_COL_DUMP"),
    TX_ID("Txid", 30, 16384, true, true, false, true, "XLOG_COL_TX_ID"),
    GX_ID("Gxid", 30, 16384, true, true, false, true, "XLOG_COL_GX_ID"),
    START_TIME("StartTime", 70, 0x1000000, true, true, true, true, "XLOG_COL_START_TIME"),
    UA("UA", 70, 16384, true, true, false, false, "XLOG_COL_UA"),
    COUNTRY("Country", 40, 16384, true, true, false, false, "XLOG_COL_COUNTRY"),
    CITY("City", 40, 16384, true, true, false, false, "XLOG_COL_CITY"),
    GROUP("Group", 40, 16384, true, true, false, false, "GROUP");

    private final String title;
    private int width;
    private final int alignment;
    private final boolean resizable;
    private final boolean moveable;
    private final boolean isNumber;
    private final boolean defaultVisible;
    private final String internalID;
    private static final long serialVersionUID = -1477341833201236951L;

    private XLogColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber, boolean defaultVisible, String internalID) {
        this.title = text;
        this.width = width;
        this.alignment = alignment;
        this.resizable = resizable;
        this.moveable = moveable;
        this.isNumber = isNumber;
        this.defaultVisible = defaultVisible;
        this.internalID = internalID;
    }

    public String getTitle() {
        return this.title;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isNumber() {
        return this.isNumber;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isDefaultVisible() {
        return this.defaultVisible;
    }

    public String getInternalID() {
        return this.internalID;
    }

    public static XLogColumnEnum findByTitle(String title) {
        XLogColumnEnum[] xLogColumnEnumArray = XLogColumnEnum.values();
        int n = xLogColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            XLogColumnEnum columnEnum = xLogColumnEnumArray[n2];
            if (columnEnum.getTitle().equals(title)) {
                return columnEnum;
            }
            ++n2;
        }
        throw new RuntimeException(String.format("[FATAL] Invalid XLogColumn title : <%s>", title));
    }
}

