/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IEntityConnectionStyleProvider;
import org.eclipse.zest.core.viewers.IEntityStyleProvider;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.model.XLogProxy;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.EditableMessageDialog;
import scouter.client.popup.SQLFormatDialog;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.client.xlog.actions.OpenXLogProfileJob;
import scouter.io.DataInputX;
import scouter.lang.CountryCode;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.XLogPack;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.ApiCallSum;
import scouter.lang.step.DispatchStep;
import scouter.lang.step.SpanCallStep;
import scouter.lang.step.SqlStep;
import scouter.lang.step.SqlSum;
import scouter.lang.step.Step;
import scouter.lang.step.ThreadCallPossibleStep;
import scouter.lang.step.ThreadSubmitStep;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.FormatUtil;
import scouter.util.HashUtil;
import scouter.util.Hexa32;
import scouter.util.IPUtil;
import scouter.util.LinkedMap;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;
import scouter.util.StringUtil;

public class XLogFlowView
extends ViewPart {
    public static final String ID = XLogFlowView.class.getName();
    private GraphViewer viewer = null;
    private String date;
    boolean showSql = true;
    boolean showApicall = true;
    ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof DependencyElement) {
                DependencyElement de = (DependencyElement)element;
                switch (de.type) {
                    case SQL: {
                        return XLogFlowView.this.showSql;
                    }
                    case API_CALL: 
                    case DISPATCH: {
                        return XLogFlowView.this.showApicall;
                    }
                }
            }
            return true;
        }
    };

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        parent.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                XLogFlowView.this.viewer.applyLayout();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.viewer = new GraphViewer(parent, 0);
        this.viewer.setContentProvider((IContentProvider)new GraphContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GraphLabelProvider());
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof DependencyElement) {
                    DependencyElement de = (DependencyElement)o;
                    switch (de.type) {
                        case SERVICE: {
                            new OpenXLogProfileJob(XLogFlowView.this.getViewSite().getShell().getDisplay(), XLogFlowView.this.date, de.id, de.tags.getInt("serverId")).schedule();
                            break;
                        }
                        case SQL: {
                            ArrayList srList = new ArrayList();
                            StringBuffer sb = new StringBuffer();
                            String sql = de.tags.getText("sql");
                            sb.append(sql);
                            String error = null;
                            if (de.error != 0) {
                                error = TextProxy.error.getLoadText(XLogFlowView.this.date, de.error, de.tags.getInt("serverId"));
                            }
                            new SQLFormatDialog().show(sb.toString(), error);
                            break;
                        }
                        case API_CALL: {
                            String error;
                            ArrayList<StyleRange> srList = new ArrayList<StyleRange>();
                            StringBuffer sb = new StringBuffer();
                            String apicall = de.name;
                            sb.append(apicall);
                            if (de.error != 0 && StringUtil.isNotEmpty((String)(error = TextProxy.error.getLoadText(XLogFlowView.this.date, de.error, de.tags.getInt("serverId"))))) {
                                sb.append("\n");
                                srList.add(new StyleRange(sb.length(), error.length(), ColorUtil.getInstance().getColor("red"), null, 1));
                                sb.append(error);
                            }
                            new EditableMessageDialog().show("API Call", sb.toString(), srList);
                            break;
                        }
                        case DISPATCH: 
                        case THREAD: {
                            new OpenXLogProfileJob(XLogFlowView.this.getViewSite().getShell().getDisplay(), XLogFlowView.this.date, de.id, de.tags.getInt("serverId")).schedule();
                        }
                    }
                }
            }
        });
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        Action sqlFilterAct = new Action("Show SQL", 2){

            public void run() {
                XLogFlowView.this.showSql = this.isChecked();
                XLogFlowView.this.viewer.refresh();
                XLogFlowView.this.viewer.applyLayout();
            }
        };
        sqlFilterAct.setImageDescriptor(ImageUtil.getImageDescriptor(Images.database));
        man.add((IAction)sqlFilterAct);
        sqlFilterAct.setChecked(true);
        Action apiFilterAct = new Action("Show API Call", 2){

            public void run() {
                XLogFlowView.this.showApicall = this.isChecked();
                XLogFlowView.this.viewer.refresh();
                XLogFlowView.this.viewer.applyLayout();
            }
        };
        apiFilterAct.setImageDescriptor(ImageUtil.getImageDescriptor(Images.link));
        man.add((IAction)apiFilterAct);
        apiFilterAct.setChecked(true);
        this.viewer.setFilters(new ViewerFilter[]{this.filter});
    }

    public void loadByTxId(String date, long txid) {
        this.date = date;
        this.setPartName("Service Flow - " + Hexa32.toString32((long)txid));
        MapPack param = new MapPack();
        param.put("date", date);
        param.put("txid", txid);
        new ProcessDependencyTask("XLOG_READ_BY_TXID", param).schedule();
    }

    public void loadByGxId(String date, long gxId) {
        this.date = date;
        this.setPartName("Service Flow - " + Hexa32.toString32((long)gxId));
        MapPack param = new MapPack();
        param.put("date", date);
        param.put("gxid", gxId);
        new ProcessDependencyTask("XLOG_READ_BY_GXID", param).schedule();
    }

    public void setFocus() {
    }

    private void collectElement(LinkedMap<Long, DependencyElement> childMap, ArrayList<DependencyElement> list) {
        Enumeration values = childMap.values();
        while (values.hasMoreElements()) {
            DependencyElement element = (DependencyElement)values.nextElement();
            list.add(element);
            this.collectElement(element.childMap, list);
        }
    }

    public static void main(String[] args) {
        String str = "SELECT * FROM (\t\tSELECT CEIL(ROWNUM  '@' ) pg , cc.* FROM (\t\tSELECT a.news_no";
        System.out.println(str.replaceAll("\\s+", " "));
    }

    public static class DependencyElement {
        ElementType type;
        long id;
        int dupleCnt = 1;
        LinkedMap<Long, DependencyElement> childMap = new LinkedMap();
        public String name;
        public int elapsed;
        public int error;
        public byte xtype;
        public String address;
        public String threadName;
        MapValue tags = new MapValue();

        DependencyElement(ElementType type, long id) {
            this.type = type;
            this.id = id;
        }

        public void addChild(DependencyElement child) {
            DependencyElement obj = (DependencyElement)this.childMap.get((Object)child.id);
            if (obj == null) {
                this.childMap.put((Object)child.id, (Object)child);
            } else {
                obj.dupleCnt += child.dupleCnt;
                obj.elapsed += child.elapsed;
                if (child.error != 0) {
                    obj.error = child.error;
                }
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyElement other = (DependencyElement)obj;
            return this.id == other.id;
        }
    }

    static enum ElementType {
        USER,
        SERVICE,
        API_CALL,
        SQL,
        DISPATCH,
        THREAD;

    }

    class GraphContentProvider
    implements IGraphEntityContentProvider {
        LongKeyLinkedMap<DependencyElement> root;

        GraphContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                this.root = (LongKeyLinkedMap)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<DependencyElement> list = new ArrayList<DependencyElement>();
            LongEnumer ipEnumer = this.root.keys();
            while (ipEnumer.hasMoreElements()) {
                long id = ipEnumer.nextLong();
                DependencyElement ipElement = (DependencyElement)this.root.get(id);
                list.add(ipElement);
                XLogFlowView.this.collectElement(ipElement.childMap, list);
            }
            return list.toArray(new DependencyElement[list.size()]);
        }

        public Object[] getConnectedTo(Object entity) {
            if (entity instanceof DependencyElement) {
                ArrayList<DependencyElement> list = new ArrayList<DependencyElement>();
                DependencyElement element = (DependencyElement)entity;
                Enumeration values = element.childMap.values();
                while (values.hasMoreElements()) {
                    DependencyElement de = (DependencyElement)values.nextElement();
                    list.add(de);
                }
                return list.toArray(new DependencyElement[list.size()]);
            }
            return null;
        }
    }

    class GraphLabelProvider
    extends LabelProvider
    implements IEntityStyleProvider,
    IEntityConnectionStyleProvider {
        GraphLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof DependencyElement) {
                DependencyElement de = (DependencyElement)element;
                if (de.name == null) {
                    de.name = "";
                }
                switch (de.type) {
                    case API_CALL: 
                    case SQL: {
                        String name1 = de.name.trim().replaceAll("[\r\n]+", " ").replaceAll("\\s+", " ");
                        if (name1.length() > 40 && name1.length() <= 65) {
                            name1 = String.valueOf(name1.substring(0, 30)) + "\n   " + name1.substring(30);
                        } else if (name1.length() > 65) {
                            name1 = String.valueOf(name1.substring(0, 30)) + "\n   " + name1.substring(30, 60) + "...";
                        }
                        return name1;
                    }
                    case DISPATCH: 
                    case THREAD: {
                        String name2 = de.name.trim().replaceAll("[\r\n]+", " ").replaceAll("\\s+", " ");
                        if (name2.length() > 40 && name2.length() <= 65) {
                            name2 = String.valueOf(name2.substring(0, 30)) + "\n   " + name2.substring(30);
                        } else if (name2.length() > 65) {
                            name2 = String.valueOf(name2.substring(0, 30)) + "\n   " + name2.substring(30, 60) + "...";
                        }
                        if (de.threadName != null) {
                            name2 = String.valueOf(name2) + "\n  <" + de.threadName + ">";
                        }
                        return name2;
                    }
                }
                String elementText = de.address != null ? String.valueOf(de.name) + "\n  : " + de.address : de.name;
                return elementText;
            }
            if (element instanceof EntityConnectionData && ((EntityConnectionData)element).dest instanceof DependencyElement) {
                DependencyElement de = (DependencyElement)((EntityConnectionData)element).dest;
                String elapsed = String.valueOf(FormatUtil.print((Object)de.elapsed, (String)"#,###")) + " ms";
                if (de.dupleCnt > 1) {
                    return "(" + de.dupleCnt + ") " + elapsed;
                }
                return elapsed;
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof DependencyElement) {
                DependencyElement de = (DependencyElement)element;
                switch (de.type) {
                    case USER: {
                        return Images.CONFIG_USER;
                    }
                    case SERVICE: {
                        return Images.server;
                    }
                    case API_CALL: {
                        return Images.link;
                    }
                    case SQL: {
                        return Images.database;
                    }
                    case DISPATCH: {
                        return Images.arrow_right;
                    }
                    case THREAD: {
                        return Images.timer;
                    }
                }
            }
            return null;
        }

        public Color getNodeHighlightColor(Object entity) {
            return ColorUtil.getInstance().getColor(1);
        }

        public Color getBorderColor(Object entity) {
            if (entity instanceof DependencyElement) {
                DependencyElement de = (DependencyElement)entity;
                if (de.type == ElementType.SERVICE) {
                    if (de.xtype == 3 || de.xtype == 4) {
                        return ColorUtil.getInstance().getColor(15);
                    }
                    return ColorUtil.getInstance().getColor(10);
                }
                return ColorUtil.getInstance().getColor(1);
            }
            return null;
        }

        public Color getBorderHighlightColor(Object entity) {
            return null;
        }

        public int getBorderWidth(Object entity) {
            if (entity instanceof DependencyElement) {
                DependencyElement de = (DependencyElement)entity;
                if (de.type == ElementType.SERVICE) {
                    return 1;
                }
            }
            return 0;
        }

        public Color getBackgroundColour(Object entity) {
            if (entity instanceof DependencyElement) {
                return ColorUtil.getInstance().getColor(1);
            }
            return null;
        }

        public Color getForegroundColour(Object entity) {
            if (entity instanceof DependencyElement) {
                DependencyElement de = (DependencyElement)entity;
                if (de.xtype == 3 || de.xtype == 4) {
                    return ColorUtil.getInstance().getColor(16);
                }
            }
            return null;
        }

        public IFigure getTooltip(Object entity) {
            return null;
        }

        public boolean fisheyeNode(Object entity) {
            return false;
        }

        public int getConnectionStyle(Object src, Object dest) {
            return 2;
        }

        public Color getColor(Object src, Object dest) {
            if (dest instanceof DependencyElement) {
                DependencyElement de = (DependencyElement)dest;
                if (de.error != 0) {
                    return ColorUtil.getInstance().getColor(3);
                }
            }
            return null;
        }

        public Color getHighlightColor(Object src, Object dest) {
            return null;
        }

        public int getLineWidth(Object src, Object dest) {
            return 0;
        }
    }

    class ProcessDependencyTask
    extends Job {
        final String requestCmd;
        final MapPack param;
        LongKeyLinkedMap<DependencyElement> rootMap;
        LongKeyLinkedMap<DependencyElement> serviceMap;

        public ProcessDependencyTask(String requestCmd, MapPack param) {
            super("Processing Dependencies Task");
            this.rootMap = new LongKeyLinkedMap();
            this.serviceMap = new LongKeyLinkedMap();
            this.requestCmd = requestCmd;
            this.param = param;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Collecting XLog/Profile....", -1);
            for (final int serverId : ServerManager.getInstance().getOpenServerList()) {
                TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
                try {
                    try {
                        tcp.process(this.requestCmd, this.param, new INetReader(){

                            @Override
                            public void process(DataInputX in) throws IOException {
                                XLogPack xlog = (XLogPack)in.readPack();
                                ElementType eType = ElementType.SERVICE;
                                boolean excludeObjName = false;
                                switch (xlog.xType) {
                                    case 3: {
                                        eType = ElementType.DISPATCH;
                                        excludeObjName = true;
                                        break;
                                    }
                                    case 4: {
                                        eType = ElementType.THREAD;
                                        excludeObjName = true;
                                    }
                                }
                                DependencyElement serviceElement = new DependencyElement(eType, xlog.txid);
                                String objName = TextProxy.object.getLoadText(((ProcessDependencyTask)ProcessDependencyTask.this).XLogFlowView.this.date, xlog.objHash, serverId);
                                String serviceName = TextProxy.service.getLoadText(((ProcessDependencyTask)ProcessDependencyTask.this).XLogFlowView.this.date, xlog.service, serverId);
                                serviceElement.elapsed = xlog.elapsed;
                                serviceElement.name = excludeObjName ? serviceName : String.valueOf(serviceName) + "\n(" + objName + ")";
                                serviceElement.error = xlog.error;
                                serviceElement.xtype = xlog.xType;
                                serviceElement.threadName = TextProxy.hashMessage.getLoadText(((ProcessDependencyTask)ProcessDependencyTask.this).XLogFlowView.this.date, xlog.threadNameHash, serverId);
                                serviceElement.tags.put("caller", xlog.caller);
                                serviceElement.tags.put("ip", IPUtil.toString((byte[])xlog.ipaddr));
                                serviceElement.tags.put("serverId", (long)serverId);
                                if (StringUtil.isNotEmpty((String)xlog.countryCode)) {
                                    serviceElement.tags.put("country", CountryCode.getCountryName((String)xlog.countryCode));
                                    serviceElement.tags.put("city", TextProxy.city.getLoadText(((ProcessDependencyTask)ProcessDependencyTask.this).XLogFlowView.this.date, xlog.city, serverId));
                                }
                                ProcessDependencyTask.this.serviceMap.put(xlog.txid, (Object)serviceElement);
                            }
                        });
                    }
                    catch (Throwable th) {
                        ConsoleProxy.errorSafe(th.toString());
                        TcpProxy.putTcpProxy(tcp);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
            LongEnumer txidEnumer = this.serviceMap.keys();
            while (txidEnumer.hasMoreElements()) {
                DependencyElement serviceElement;
                block14: {
                    long txid = txidEnumer.nextLong();
                    serviceElement = (DependencyElement)this.serviceMap.get(txid);
                    final int serverId = (int)serviceElement.tags.getLong("serverId");
                    if (serverId == 0) continue;
                    TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("date", XLogFlowView.this.date);
                            param.put("txid", (Value)new DecimalValue(txid));
                            tcp.process("TRANX_PROFILE_FULL", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    byte[] buff = in.readBlob();
                                    Step[] steps = Step.toObjects((byte[])buff);
                                    if (steps == null) {
                                        return;
                                    }
                                    Step[] stepArray = steps;
                                    int n = steps.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Step step = stepArray[n2];
                                        ProcessDependencyTask.this.stepToElement(serviceElement, step, serverId);
                                        ++n2;
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            ConsoleProxy.errorSafe(e.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (this.serviceMap.size() != 1 && serviceElement.tags.getLong("caller") != 0L) continue;
                String ip = serviceElement.tags.getText("ip");
                if (StringUtil.isNotEmpty((String)ip)) {
                    int id = HashUtil.hash((String)ip);
                    DependencyElement ipElement = (DependencyElement)this.rootMap.get((long)id);
                    if (ipElement == null) {
                        ipElement = new DependencyElement(ElementType.USER, id);
                        ipElement.name = StringUtil.isNotEmpty((String)serviceElement.tags.getText("country")) ? String.valueOf(ip) + "\n(" + serviceElement.tags.getText("city") + ", " + serviceElement.tags.getText("country") + ")" : ip;
                        this.rootMap.put((long)id, (Object)ipElement);
                    }
                    ipElement.addChild(serviceElement);
                    continue;
                }
                long id = TimeUtil.getCurrentTime();
                DependencyElement dummyElement = new DependencyElement(ElementType.USER, id);
                dummyElement.name = "???.???.???.???";
                this.rootMap.put(id, (Object)dummyElement);
            }
            ExUtil.exec((Composite)XLogFlowView.this.viewer.getGraphControl(), new Runnable(){

                @Override
                public void run() {
                    ((ProcessDependencyTask)ProcessDependencyTask.this).XLogFlowView.this.viewer.setInput(ProcessDependencyTask.this.rootMap);
                }
            });
            return Status.OK_STATUS;
        }

        private void stepToElement(final DependencyElement serviceElement, Step step, final int serverId) {
            switch (step.getStepType()) {
                case 6: 
                case 15: {
                    ApiCallStep apicallstep = (ApiCallStep)step;
                    DependencyElement apiElement = new DependencyElement(ElementType.API_CALL, apicallstep.txid + (long)apicallstep.hash);
                    apiElement.elapsed = apicallstep.elapsed;
                    apiElement.error = apicallstep.error;
                    apiElement.name = TextProxy.apicall.getLoadText(XLogFlowView.this.date, apicallstep.hash, serverId);
                    apiElement.tags.put("serverId", (long)serverId);
                    apiElement.address = apicallstep.address;
                    if (apicallstep.txid != 0L) {
                        DependencyElement calledService = (DependencyElement)this.serviceMap.get(apicallstep.txid);
                        if (calledService != null) {
                            calledService.address = apicallstep.address;
                            serviceElement.addChild(calledService);
                            break;
                        }
                        serviceElement.addChild(apiElement);
                        break;
                    }
                    serviceElement.addChild(apiElement);
                    break;
                }
                case 52: {
                    SpanCallStep spanCallstep = (SpanCallStep)step;
                    DependencyElement spanCallElement = new DependencyElement(ElementType.API_CALL, spanCallstep.txid + (long)spanCallstep.hash);
                    spanCallElement.elapsed = spanCallstep.elapsed;
                    spanCallElement.error = spanCallstep.error;
                    spanCallElement.name = TextProxy.apicall.getLoadText(XLogFlowView.this.date, spanCallstep.hash, serverId);
                    spanCallElement.tags.put("serverId", (long)serverId);
                    spanCallElement.address = spanCallstep.address;
                    if (spanCallstep.txid != 0L) {
                        DependencyElement calledService = (DependencyElement)this.serviceMap.get(spanCallstep.txid);
                        if (calledService != null) {
                            calledService.address = spanCallstep.address;
                            serviceElement.addChild(calledService);
                            break;
                        }
                        serviceElement.addChild(spanCallElement);
                        break;
                    }
                    serviceElement.addChild(spanCallElement);
                    break;
                }
                case 13: {
                    DispatchStep dispatchStep = (DispatchStep)step;
                    DependencyElement dispatchElement = new DependencyElement(ElementType.DISPATCH, dispatchStep.txid + (long)dispatchStep.hash);
                    dispatchElement.elapsed = dispatchStep.elapsed;
                    dispatchElement.error = dispatchStep.error;
                    dispatchElement.name = TextProxy.apicall.getLoadText(XLogFlowView.this.date, dispatchStep.hash, serverId);
                    dispatchElement.tags.put("serverId", (long)serverId);
                    if (dispatchStep.txid != 0L) {
                        DependencyElement calledService = (DependencyElement)this.serviceMap.get(dispatchStep.txid);
                        if (calledService != null) {
                            serviceElement.addChild(calledService);
                            break;
                        }
                        serviceElement.addChild(dispatchElement);
                        break;
                    }
                    serviceElement.addChild(dispatchElement);
                    break;
                }
                case 14: {
                    ThreadCallPossibleStep tcStep = (ThreadCallPossibleStep)step;
                    XLogData threadStepXlog = null;
                    if (tcStep.txid != 0L) {
                        threadStepXlog = XLogProxy.getXLogData(serverId, XLogFlowView.this.date, tcStep.txid);
                    }
                    if (threadStepXlog != null) {
                        tcStep.threaded = 1;
                        tcStep.elapsed = threadStepXlog.p.elapsed;
                    }
                    if (tcStep.threaded == 0) break;
                    DependencyElement tcElement = new DependencyElement(ElementType.DISPATCH, tcStep.txid + (long)tcStep.hash);
                    tcElement.elapsed = tcStep.elapsed;
                    tcElement.name = TextProxy.apicall.getLoadText(XLogFlowView.this.date, tcStep.hash, serverId);
                    tcElement.tags.put("serverId", (long)serverId);
                    if (tcStep.txid != 0L) {
                        DependencyElement calledService = (DependencyElement)this.serviceMap.get(tcStep.txid);
                        if (calledService != null) {
                            serviceElement.addChild(calledService);
                            break;
                        }
                        serviceElement.addChild(tcElement);
                        break;
                    }
                    serviceElement.addChild(tcElement);
                    break;
                }
                case 43: {
                    ApiCallSum apicallsum = (ApiCallSum)step;
                    DependencyElement apiSumElement = new DependencyElement(ElementType.API_CALL, apicallsum.hash);
                    apiSumElement.dupleCnt = apicallsum.count;
                    apiSumElement.elapsed = (int)apicallsum.elapsed;
                    apiSumElement.error = apicallsum.error;
                    apiSumElement.name = TextProxy.apicall.getLoadText(XLogFlowView.this.date, apicallsum.hash, serverId);
                    apiSumElement.tags.put("serverId", (long)serverId);
                    serviceElement.addChild(apiSumElement);
                    break;
                }
                case 2: 
                case 8: 
                case 16: {
                    SqlStep sqlstep = (SqlStep)step;
                    DependencyElement sqlElement = new DependencyElement(ElementType.SQL, sqlstep.hash);
                    sqlElement.elapsed = sqlstep.elapsed;
                    String table = TextProxy.sql_tables.getLoadText(XLogFlowView.this.date, sqlstep.hash, serverId);
                    String sql = TextProxy.sql.getLoadText(XLogFlowView.this.date, sqlstep.hash, serverId).trim();
                    sqlElement.name = StringUtil.isNotEmpty((String)table) ? table : String.valueOf(StringUtil.truncate((String)sql, (int)20)) + "...";
                    sqlElement.error = sqlstep.error;
                    sqlElement.tags.put("serverId", (long)serverId);
                    sqlElement.tags.put("sql", sql);
                    serviceElement.addChild(sqlElement);
                    break;
                }
                case 21: {
                    SqlSum sqlsum = (SqlSum)step;
                    DependencyElement sqlSumElement = new DependencyElement(ElementType.SQL, sqlsum.hash);
                    sqlSumElement.dupleCnt = sqlsum.count;
                    sqlSumElement.elapsed = (int)sqlsum.elapsed;
                    sqlSumElement.error = sqlsum.error;
                    String table = TextProxy.sql_tables.getLoadText(XLogFlowView.this.date, sqlsum.hash, serverId);
                    String sql = TextProxy.sql.getLoadText(XLogFlowView.this.date, sqlsum.hash, serverId).trim();
                    sqlSumElement.name = StringUtil.isNotEmpty((String)table) ? table : String.valueOf(StringUtil.truncate((String)sql, (int)20)) + "...";
                    sqlSumElement.tags.put("serverId", (long)serverId);
                    sqlSumElement.tags.put("sql", sql);
                    serviceElement.addChild(sqlSumElement);
                    break;
                }
                case 7: {
                    ThreadSubmitStep tsStep = (ThreadSubmitStep)step;
                    TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("date", XLogFlowView.this.date);
                            param.put("txid", tsStep.txid);
                            tcp.process("TRANX_PROFILE_FULL", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    byte[] buff = in.readBlob();
                                    Step[] steps = Step.toObjects((byte[])buff);
                                    if (steps == null) {
                                        return;
                                    }
                                    Step[] stepArray = steps;
                                    int n = steps.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Step step = stepArray[n2];
                                        ProcessDependencyTask.this.stepToElement(serviceElement, step, serverId);
                                        ++n2;
                                    }
                                }
                            });
                        }
                        catch (Throwable th) {
                            ConsoleProxy.errorSafe(th.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break;
                        }
                    }
                    finally {
                        TcpProxy.putTcpProxy(tcp);
                    }
                }
            }
        }
    }
}

