/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Activator;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MyKeyAdapter;
import scouter.client.util.StepWrapper;
import scouter.client.util.UIUtil;
import scouter.client.xlog.SaveProfileJob;
import scouter.client.xlog.XLogUtil;
import scouter.lang.pack.XLogPack;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.ApiCallSum;
import scouter.lang.step.DispatchStep;
import scouter.lang.step.MessageStep;
import scouter.lang.step.MethodStep;
import scouter.lang.step.MethodSum;
import scouter.lang.step.SqlStep;
import scouter.lang.step.SqlSum;
import scouter.lang.step.Step;
import scouter.lang.step.StepSingle;
import scouter.lang.step.StepSummary;
import scouter.lang.step.ThreadCallPossibleStep;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.Hexa32;
import scouter.util.StringUtil;
import scouter.util.SystemUtil;

public class XLogFullProfileView
extends ViewPart
implements UIUtil.XLogViewWithTable {
    public static final String ID = XLogFullProfileView.class.getName();
    private StyledText header;
    private StyledText text;
    Button prevBtn;
    Button nextBtn;
    Button endBtn;
    Button startBtn;
    Button summaryBtn;
    Text targetPage;
    Label totalPage;
    Label totalProfile;
    private IMemento memento;
    IToolBarManager man;
    Action spaceNarrow;
    Action spaceWide;
    int pageNum = 0;
    int rowPerPage = 30;
    SashForm sashForm;
    Action showSearchAreaBtn;
    Composite mainComposite;
    String[] titles = new String[]{"Page", "Profile"};
    Text searchText;
    Table searchResultTable;
    Label searchLbl;
    ProgressBar searchProg;
    Button searchBtn;
    Button stopBtn;
    Text searchFromTxt;
    Text searchToTxt;
    Text maxCountTxt;
    MyKeyAdapter adapter;
    private final int SORT_WITH_COUNT = 100;
    private final int SORT_WITH_SUM = 200;
    private final int SORT_WITH_AVG = 300;
    private int CURRENT_SORT_CRITERIA = 100;
    Button sortCountBtn;
    Button sortSumBtn;
    Button sortAvgBtn;
    private int searchLineIndex = -1;
    int index;
    String m = "";
    int prog = 0;
    String searchTxt;
    boolean breakSearch = false;
    int maxCount = 0;
    int searchCnt = 0;
    private final int TYPE_MESSAGE = 102;
    private final int TYPE_SQL = 103;
    private final int TYPE_METHOD = 104;
    private final int TYPE_APICALL = 105;
    XLogPack p;
    StepWrapper[] profiles;
    int total;
    private int serverId;
    private boolean isSummary;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void createPartControl(Composite parent) {
        this.adapter = new MyKeyAdapter(parent.getShell(), "SelectedLog.txt");
        this.man = this.getViewSite().getActionBars().getToolBarManager();
        this.sashForm = new SashForm(parent, 256);
        this.sashForm.setBackground(parent.getDisplay().getSystemColor(15));
        this.sashForm.SASH_WIDTH = 1;
        this.mainComposite = new Composite((Composite)this.sashForm, 0);
        this.mainComposite.setLayout((Layout)new GridLayout(1, true));
        this.header = new StyledText(this.mainComposite, 2882);
        GridData bodyData = new GridData(4, 4, true, false);
        bodyData.heightHint = 100;
        this.header.setLayoutData((Object)bodyData);
        this.header.setText("");
        if (SystemUtil.IS_MAC_OSX) {
            this.header.setFont(new Font(null, "Courier New", 12, 0));
        } else {
            this.header.setFont(new Font(null, "Courier New", 10, 0));
        }
        this.header.setBackgroundImage(Activator.getImage("icons/grid.jpg"));
        Composite centerComp = new Composite(this.mainComposite, 0);
        bodyData = new GridData(4, 4, true, false);
        bodyData.heightHint = 55;
        centerComp.setLayoutData((Object)bodyData);
        centerComp.setLayout((Layout)UIUtil.formLayout(5, 5));
        this.summaryBtn = new Button(centerComp, 2);
        this.summaryBtn.setText("Summary");
        this.summaryBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, 100, 0, null, -1));
        this.summaryBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    XLogFullProfileView.this.getSummary();
                } else {
                    XLogFullProfileView.this.pageNum = 0;
                    XLogFullProfileView.this.setProfile();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.endBtn = new Button(centerComp, 0);
        this.endBtn.setImage(Images.toend);
        this.endBtn.setText("");
        this.endBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, this.summaryBtn, 0, null, -1, 40));
        this.endBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XLogFullProfileView.this.pageNum = XLogFullProfileView.this.total - 1;
                XLogFullProfileView.this.targetPage.setText("" + (XLogFullProfileView.this.pageNum + 1));
                XLogFullProfileView.this.setProfile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.nextBtn = new Button(centerComp, 0);
        this.nextBtn.setImage(Images.tonext);
        this.nextBtn.setText("Next");
        this.nextBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, this.endBtn, 0, null, -1, 80));
        this.nextBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ++XLogFullProfileView.this.pageNum;
                XLogFullProfileView.this.targetPage.setText("" + (XLogFullProfileView.this.pageNum + 1));
                XLogFullProfileView.this.setProfile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.prevBtn = new Button(centerComp, 0);
        this.prevBtn.setImage(Images.toprev);
        this.prevBtn.setText("Before");
        this.prevBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, this.nextBtn, 0, null, -1, 80));
        this.prevBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                --XLogFullProfileView.this.pageNum;
                XLogFullProfileView.this.targetPage.setText("" + (XLogFullProfileView.this.pageNum + 1));
                XLogFullProfileView.this.setProfile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.startBtn = new Button(centerComp, 0);
        this.startBtn.setImage(Images.tostart);
        this.startBtn.setText("");
        this.startBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, this.prevBtn, 0, null, -1, 40));
        this.startBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XLogFullProfileView.this.pageNum = 0;
                XLogFullProfileView.this.targetPage.setText("" + (XLogFullProfileView.this.pageNum + 1));
                XLogFullProfileView.this.setProfile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.totalPage = new Label(centerComp, 0);
        this.totalPage.setLayoutData((Object)UIUtil.formData(null, -1, 0, 3, this.startBtn, 0, null, -1, 60));
        this.totalProfile = new Label(centerComp, 0);
        this.totalProfile.setLayoutData((Object)UIUtil.formData(0, 0, 0, 3, null, -1, null, -1, 100));
        this.targetPage = new Text(centerComp, 133120);
        this.targetPage.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, this.totalPage, 0, null, -1, 60));
        this.targetPage.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    XLogFullProfileView.this.pageNum = CastUtil.cint((Object)XLogFullProfileView.this.targetPage.getText()) - 1;
                    if (XLogFullProfileView.this.pageNum > XLogFullProfileView.this.total) {
                        XLogFullProfileView.this.pageNum = XLogFullProfileView.this.total - 1;
                    }
                    XLogFullProfileView.this.targetPage.setText("" + (XLogFullProfileView.this.pageNum + 1));
                    XLogFullProfileView.this.setProfile();
                }
            }
        });
        this.targetPage.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text text = (Text)e.getSource();
                String oldS = text.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                boolean isFloat = true;
                try {
                    Float.parseFloat(newS);
                }
                catch (NumberFormatException ex) {
                    isFloat = false;
                }
                if (!isFloat) {
                    e.doit = false;
                }
            }
        });
        this.sortCountBtn = new Button(centerComp, 0);
        this.sortCountBtn.setText("Count");
        this.sortCountBtn.setLayoutData((Object)UIUtil.formData(0, 2, this.totalProfile, 8, null, -1, null, -1, 70));
        this.sortCountBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XLogFullProfileView.this.CURRENT_SORT_CRITERIA = 100;
                XLogFullProfileView.this.getSummary();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.sortSumBtn = new Button(centerComp, 0);
        this.sortSumBtn.setText("Sum");
        this.sortSumBtn.setLayoutData((Object)UIUtil.formData(this.sortCountBtn, 20, this.totalProfile, 8, null, -1, null, -1, 70));
        this.sortSumBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XLogFullProfileView.this.CURRENT_SORT_CRITERIA = 200;
                XLogFullProfileView.this.getSummary();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.sortAvgBtn = new Button(centerComp, 0);
        this.sortAvgBtn.setText("Avg");
        this.sortAvgBtn.setLayoutData((Object)UIUtil.formData(this.sortSumBtn, 20, this.totalProfile, 8, null, -1, null, -1, 70));
        this.sortAvgBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XLogFullProfileView.this.CURRENT_SORT_CRITERIA = 300;
                XLogFullProfileView.this.getSummary();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.text = new StyledText(this.mainComposite, 2818);
        bodyData = new GridData(4, 4, true, true);
        this.text.setLayoutData((Object)bodyData);
        this.text.setText("");
        if (SystemUtil.IS_MAC_OSX) {
            this.text.setFont(new Font(null, "Courier New", 12, 0));
        } else {
            this.text.setFont(new Font(null, "Courier New", 10, 0));
        }
        this.text.setBackgroundImage(Activator.getImage("icons/grid.jpg"));
        this.text.addKeyListener((KeyListener)this.adapter);
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 102) {
                    XLogFullProfileView.this.showSearchAreaBtn.setChecked(true);
                    XLogFullProfileView.this.sashForm.setMaximizedControl(null);
                    XLogFullProfileView.this.searchText.setFocus();
                }
            }
        });
        Composite searchComposite = new Composite((Composite)this.sashForm, 0);
        GridLayout searchLayout = new GridLayout(2, true);
        searchComposite.setLayout((Layout)searchLayout);
        Composite searchArea = new Composite(searchComposite, 0);
        searchArea.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        searchArea.setLayout((Layout)UIUtil.formLayout(1, 1));
        Label pageLbl = new Label(searchArea, 0);
        pageLbl.setText("Page:");
        pageLbl.setLayoutData((Object)UIUtil.formData(0, 2, 0, 2, null, -1, null, -1, 70));
        this.searchFromTxt = new Text(searchArea, 133120);
        this.searchFromTxt.setLayoutData((Object)UIUtil.formData(pageLbl, 2, 0, 0, null, -1, null, -1, 45));
        Label fromToLbl = new Label(searchArea, 0);
        fromToLbl.setText("~");
        fromToLbl.setLayoutData((Object)UIUtil.formData(this.searchFromTxt, 2, 0, 2, null, -1, null, -1));
        this.searchToTxt = new Text(searchArea, 133120);
        this.searchToTxt.setLayoutData((Object)UIUtil.formData(fromToLbl, 2, 0, 0, 100, -5, null, -1));
        Label maxLbl = new Label(searchArea, 0);
        maxLbl.setText("Max Count:");
        maxLbl.setLayoutData((Object)UIUtil.formData(0, 2, this.searchToTxt, 5, null, -1, null, -1, 70));
        this.maxCountTxt = new Text(searchArea, 133120);
        this.maxCountTxt.setLayoutData((Object)UIUtil.formData(maxLbl, 2, this.searchToTxt, 3, 100, -5, null, -1));
        this.stopBtn = new Button(searchArea, 0);
        this.stopBtn.setText("Stop");
        this.stopBtn.setLayoutData((Object)UIUtil.formData(null, -1, this.maxCountTxt, 5, 100, -5, null, -1));
        this.stopBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XLogFullProfileView.this.breakSearch = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.searchBtn = new Button(searchArea, 0);
        this.searchBtn.setText("search");
        this.searchBtn.setLayoutData((Object)UIUtil.formData(null, -1, this.maxCountTxt, 5, this.stopBtn, -5, null, -1));
        this.searchBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XLogFullProfileView.this.searchWithNewText();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.searchText = new Text(searchArea, 2048);
        this.searchText.setLayoutData((Object)UIUtil.formData(0, 2, this.maxCountTxt, 7, this.searchBtn, -5, null, -1));
        this.searchText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    XLogFullProfileView.this.searchWithNewText();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Composite labelComp = new Composite(searchComposite, 0);
        labelComp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        labelComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        this.searchLbl = new Label(labelComp, 131072);
        this.searchLbl.setLayoutData((Object)UIUtil.formData(0, 2, 0, 2, 100, -5, null, -1));
        this.searchProg = new ProgressBar(labelComp, 65536);
        this.searchProg.setVisible(false);
        this.searchProg.setLayoutData((Object)UIUtil.formData(0, 2, 0, 0, 100, -5, null, -1, -1, 10));
        Composite tableComp = new Composite(searchComposite, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.searchResultTable = new Table(tableComp, 66304);
        this.searchResultTable.setHeaderVisible(true);
        TableColumn column0 = UIUtil.create(this.searchResultTable, 131072, this.titles[0], 6, 0, false, 100, this);
        TableColumn column1 = UIUtil.create(this.searchResultTable, 0, this.titles[1], 6, 1, false, 100, this);
        int loopIndex = 0;
        while (loopIndex < this.titles.length) {
            this.searchResultTable.getColumn(loopIndex).pack();
            ++loopIndex;
        }
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        layout.setColumnData((Widget)column0, (ColumnLayoutData)new ColumnWeightData(15));
        layout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(85));
        this.searchResultTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem selectItem = (TableItem)event.item;
                XLogFullProfileView.this.searchLineIndex = CastUtil.cint((Object)selectItem.getData());
                int select = CastUtil.cint((Object)selectItem.getText(0)) - 1;
                if (XLogFullProfileView.this.pageNum != select) {
                    XLogFullProfileView.this.pageNum = select;
                    if (XLogFullProfileView.this.pageNum > XLogFullProfileView.this.total) {
                        XLogFullProfileView.this.pageNum = XLogFullProfileView.this.total - 1;
                    }
                    XLogFullProfileView.this.targetPage.setText("" + (XLogFullProfileView.this.pageNum + 1));
                }
                XLogFullProfileView.this.setProfile();
            }
        });
        this.showSearchAreaBtn = new Action("Search Text", 2){

            public void run() {
                if (XLogFullProfileView.this.showSearchAreaBtn.isChecked()) {
                    XLogFullProfileView.this.sashForm.setMaximizedControl(null);
                    XLogFullProfileView.this.searchText.setFocus();
                } else {
                    XLogFullProfileView.this.sashForm.setMaximizedControl((Control)XLogFullProfileView.this.mainComposite);
                }
            }
        };
        this.showSearchAreaBtn.setImageDescriptor(ImageUtil.getImageDescriptor(Images.SEARCH));
        this.man.add((IAction)this.showSearchAreaBtn);
        this.sashForm.setWeights(new int[]{3, 1});
        this.sashForm.setMaximizedControl(null);
        this.showSearchAreaBtn.setChecked(true);
        this.searchText.setFocus();
    }

    private void searchWithNewText() {
        this.searchTxt = this.searchText.getText();
        this.searchCnt = 0;
        if (CastUtil.cint((Object)this.searchFromTxt.getText()) < 1) {
            this.searchFromTxt.setText("1");
        }
        if (CastUtil.cint((Object)this.searchToTxt.getText()) > this.total) {
            this.searchToTxt.setText("" + this.total);
        }
        int startProfile = CastUtil.cint((Object)this.searchFromTxt.getText()) * this.rowPerPage - this.rowPerPage;
        int endProfile = CastUtil.cint((Object)this.searchToTxt.getText()) * this.rowPerPage;
        if (endProfile > this.profiles.length) {
            endProfile = this.profiles.length;
        }
        this.maxCount = CastUtil.cint((Object)this.maxCountTxt.getText());
        this.clearTable();
        this.searchWithText(startProfile, endProfile);
    }

    private void clearTable() {
        this.searchResultTable.removeAll();
    }

    private void searchWithText(final int startProfile, final int endProfile) {
        this.prog = 0;
        this.breakSearch = false;
        this.searchText.setText(this.searchTxt);
        this.setSearchWidgets(true);
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                int i = startProfile;
                while (i < endProfile && !XLogFullProfileView.this.breakSearch) {
                    StepSingle step;
                    if (XLogFullProfileView.this.profiles[i].step instanceof StepSingle) {
                        step = (StepSingle)XLogFullProfileView.this.profiles[i].step;
                        XLogFullProfileView.this.index = step.index;
                    } else {
                        step = (StepSummary)XLogFullProfileView.this.profiles[i].step;
                        XLogFullProfileView.this.index = XLogFullProfileView.this.profiles[i].sSummaryIdx;
                    }
                    XLogFullProfileView.this.m = "";
                    switch (step.getStepType()) {
                        case 1: 
                        case 10: {
                            XLogFullProfileView.this.m = TextProxy.method.getText(((MethodStep)step).hash);
                            if (XLogFullProfileView.this.m != null) break;
                            XLogFullProfileView.this.m = Hexa32.toString32((long)((MethodStep)step).hash);
                            break;
                        }
                        case 11: {
                            XLogFullProfileView.this.m = TextProxy.method.getText(((MethodSum)step).hash);
                            if (XLogFullProfileView.this.m != null) break;
                            XLogFullProfileView.this.m = Hexa32.toString32((long)((MethodSum)step).hash);
                            break;
                        }
                        case 2: 
                        case 8: 
                        case 16: {
                            SqlStep sql = (SqlStep)step;
                            XLogFullProfileView.this.m = TextProxy.sql.getText(sql.hash);
                            if (XLogFullProfileView.this.m == null) {
                                XLogFullProfileView.this.m = Hexa32.toString32((long)sql.hash);
                            }
                            if (!StringUtil.isEmpty((String)sql.param)) {
                                XLogFullProfileView.this.m = String.valueOf(XLogFullProfileView.this.m) + " [" + sql.param + "]";
                            }
                            if (sql.error == 0) break;
                            XLogFullProfileView.this.m = String.valueOf(XLogFullProfileView.this.m) + TextProxy.error.getText(sql.error);
                            break;
                        }
                        case 21: {
                            SqlSum sqlsum = (SqlSum)step;
                            XLogFullProfileView.this.m = TextProxy.sql.getText(sqlsum.hash);
                            if (XLogFullProfileView.this.m == null) {
                                XLogFullProfileView.this.m = Hexa32.toString32((long)sqlsum.hash);
                            }
                            if (!StringUtil.isEmpty((String)sqlsum.param)) {
                                XLogFullProfileView.this.m = String.valueOf(XLogFullProfileView.this.m) + " [" + sqlsum.param + "]";
                            }
                            if (sqlsum.error == 0) break;
                            XLogFullProfileView.this.m = String.valueOf(XLogFullProfileView.this.m) + TextProxy.error.getText(sqlsum.error);
                            break;
                        }
                        case 3: {
                            XLogFullProfileView.this.m = ((MessageStep)step).message;
                            break;
                        }
                        case 6: 
                        case 15: {
                            ApiCallStep apicall = (ApiCallStep)step;
                            XLogFullProfileView.this.m = TextProxy.apicall.getText(apicall.hash);
                            if (XLogFullProfileView.this.m == null) {
                                XLogFullProfileView.this.m = Hexa32.toString32((long)apicall.hash);
                            }
                            if (apicall.error == 0) break;
                            XLogFullProfileView.this.m = String.valueOf(XLogFullProfileView.this.m) + TextProxy.error.getText(apicall.error);
                            break;
                        }
                        case 43: {
                            ApiCallSum apicallsum = (ApiCallSum)step;
                            XLogFullProfileView.this.m = TextProxy.apicall.getText(apicallsum.hash);
                            if (XLogFullProfileView.this.m == null) {
                                XLogFullProfileView.this.m = Hexa32.toString32((long)apicallsum.hash);
                            }
                            if (apicallsum.error == 0) break;
                            XLogFullProfileView.this.m = String.valueOf(XLogFullProfileView.this.m) + TextProxy.error.getText(apicallsum.error);
                            break;
                        }
                        case 13: {
                            DispatchStep dispatchStep = (DispatchStep)step;
                            XLogFullProfileView.this.m = TextProxy.apicall.getText(dispatchStep.hash);
                            if (XLogFullProfileView.this.m == null) {
                                XLogFullProfileView.this.m = Hexa32.toString32((long)dispatchStep.hash);
                            }
                            if (dispatchStep.error == 0) break;
                            XLogFullProfileView.this.m = String.valueOf(XLogFullProfileView.this.m) + TextProxy.error.getText(dispatchStep.error);
                            break;
                        }
                        case 14: {
                            ThreadCallPossibleStep tcStep = (ThreadCallPossibleStep)step;
                            XLogFullProfileView.this.m = TextProxy.apicall.getText(tcStep.hash);
                            if (XLogFullProfileView.this.m != null) break;
                            XLogFullProfileView.this.m = Hexa32.toString32((long)tcStep.hash);
                        }
                    }
                    if (XLogFullProfileView.this.m.indexOf(XLogFullProfileView.this.searchTxt) != -1) {
                        XLogFullProfileView.this.searchResultTable.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).XLogFullProfileView.this.searchResultTable.isDisposed()) {
                                    return;
                                }
                                TableItem item = new TableItem((this).XLogFullProfileView.this.searchResultTable, 0);
                                item.setText(0, "" + ((this).XLogFullProfileView.this.index / (this).XLogFullProfileView.this.rowPerPage + 1));
                                item.setText(1, (this).XLogFullProfileView.this.m);
                                item.setData((Object)(this).XLogFullProfileView.this.index);
                                ++(this).XLogFullProfileView.this.searchCnt;
                            }
                        });
                    }
                    XLogFullProfileView.this.prog = i - startProfile;
                    XLogFullProfileView.this.searchResultTable.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).XLogFullProfileView.this.searchProg.setSelection((this).XLogFullProfileView.this.prog * 100 / (endProfile - startProfile));
                        }
                    });
                    if (XLogFullProfileView.this.searchCnt >= XLogFullProfileView.this.maxCount) {
                        XLogFullProfileView.this.breakSearch = true;
                    }
                    ++i;
                }
                XLogFullProfileView.this.searchResultTable.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        XLogFullProfileView.this.setSearchWidgets(false);
                    }
                });
            }
        });
    }

    private void setSearchWidgets(boolean searchDoing) {
        if (searchDoing) {
            this.searchText.setEnabled(false);
            this.searchLbl.setVisible(false);
            this.searchProg.setVisible(true);
            this.searchBtn.setEnabled(false);
        } else {
            this.searchText.setEnabled(true);
            this.searchText.setFocus();
            this.searchText.selectAll();
            this.searchLbl.setVisible(true);
            this.searchLbl.setText("Count : " + this.searchCnt);
            this.searchProg.setVisible(false);
            this.searchBtn.setEnabled(true);
        }
    }

    private void setWidgets(boolean enabled) {
        this.prevBtn.setEnabled(enabled);
        this.nextBtn.setEnabled(enabled);
        this.endBtn.setEnabled(enabled);
        this.startBtn.setEnabled(enabled);
        this.targetPage.setEnabled(enabled);
        this.sortCountBtn.setEnabled(!enabled);
        this.sortSumBtn.setEnabled(!enabled);
        this.sortAvgBtn.setEnabled(!enabled);
    }

    protected void getSummary() {
        this.setWidgets(false);
        HashMap<String, ProfileSummary> summary = new HashMap<String, ProfileSummary>();
        Color red = this.text.getDisplay().getSystemColor(3);
        Color dgreen = this.text.getDisplay().getSystemColor(6);
        int inx = 0;
        while (inx < this.profiles.length) {
            StepSingle step = (StepSingle)this.profiles[inx].step;
            switch (step.getStepType()) {
                case 1: 
                case 10: {
                    this.putSummary(summary, (MethodStep)step);
                    break;
                }
                case 2: 
                case 8: 
                case 16: {
                    this.putSummary(summary, (SqlStep)step);
                    break;
                }
                case 3: {
                    this.putSummary(summary, (MessageStep)step);
                    break;
                }
                case 6: 
                case 15: {
                    this.putSummary(summary, (ApiCallStep)step);
                }
            }
            ++inx;
        }
        ValueComparator bvc = new ValueComparator(summary);
        TreeMap<String, ProfileSummary> sorted_map = new TreeMap<String, ProfileSummary>(bvc);
        sorted_map.putAll(summary);
        StringBuffer sb = new StringBuffer();
        ArrayList<StyleRange> sr = new ArrayList<StyleRange>();
        int length = 0;
        sb.append("------------------------------------------------------------------------------------------\n");
        sb.append("   Count       Sum        Avg         Contents\n");
        sb.append("------------------------------------------------------------------------------------------\n");
        for (String key : sorted_map.keySet()) {
            ProfileSummary value = summary.get(key);
            sb.append(String.format("%10d", value.callCnt));
            sb.append(" ");
            sb.append(String.format("%10d", value.sumResTime));
            sb.append(" ");
            sb.append(String.format("%10d", value.avgResTime));
            sb.append("   ");
            length = sb.length();
            sb.append(value.name);
            switch (value.type) {
                case 102: {
                    sr.add(this.style(length, sb.length() - length, dgreen, 0));
                    break;
                }
                case 103: {
                    sr.add(this.style(length, sb.length() - length, red, 0));
                    break;
                }
                case 105: {
                    sr.add(this.style(length, sb.length() - length, red, 0));
                    break;
                }
            }
            sb.append("\n");
        }
        sb.append("------------------------------------------------------------------------------------------\n");
        this.text.setText(sb.toString());
        this.text.setStyleRanges(sr.toArray(new StyleRange[sr.size()]));
    }

    private void putSummary(HashMap<String, ProfileSummary> summary, ApiCallStep step) {
        ProfileSummary ps;
        String m = TextProxy.apicall.getText(step.hash);
        if (m == null) {
            m = Hexa32.toString32((long)step.hash);
        }
        if ((ps = summary.get(m)) == null) {
            summary.put(m, new ProfileSummary(m, 1, step.elapsed, step.elapsed, 105));
        } else {
            ps.addResTime(step.elapsed);
            summary.put(m, ps);
        }
    }

    private void putSummary(HashMap<String, ProfileSummary> summary, MessageStep step) {
        String m = step.message;
        ProfileSummary ps = summary.get(m);
        if (ps == null) {
            summary.put(m, new ProfileSummary(m, 1, 0, 0, 102));
        } else {
            ps.addResTime(0);
            summary.put(m, ps);
        }
    }

    private void putSummary(HashMap<String, ProfileSummary> summary, SqlStep step) {
        ProfileSummary ps;
        String m = TextProxy.sql.getText(step.hash);
        if (m == null) {
            m = Hexa32.toString32((long)step.hash);
        }
        if ((ps = summary.get(m)) == null) {
            summary.put(m, new ProfileSummary(m, 1, step.elapsed, step.elapsed, 103));
        } else {
            ps.addResTime(step.elapsed);
            summary.put(m, ps);
        }
    }

    private void putSummary(HashMap<String, ProfileSummary> summary, MethodStep step) {
        ProfileSummary ps;
        String m = TextProxy.method.getText(step.hash);
        if (m == null) {
            m = Hexa32.toString32((long)step.hash);
        }
        if ((ps = summary.get(m)) == null) {
            summary.put(m, new ProfileSummary(m, 1, step.elapsed, step.elapsed, 104));
        } else {
            ps.addResTime(step.elapsed);
            summary.put(m, ps);
        }
    }

    public void setInput(File xLogDir, int serverId, boolean isSummary) {
        this.serverId = serverId;
        this.isSummary = isSummary;
        this.p = SaveProfileJob.getTranxData(xLogDir, this.header, serverId);
        this.profiles = SaveProfileJob.getProfileData(this.p, xLogDir, isSummary);
        if (this.profiles == null || this.profiles.length < 1) {
            return;
        }
        String date = DateUtil.yyyymmdd((long)this.p.endTime);
        Step[] steps = new Step[this.profiles.length];
        int inx = 0;
        while (inx < this.profiles.length) {
            steps[inx] = this.profiles[inx].step;
            ++inx;
        }
        XLogUtil.loadStepText(serverId, date, steps);
        this.totalProfile.setText("Profile:" + (this.profiles[this.profiles.length - 1].getLastIndex() + 1));
        this.total = this.profiles.length / this.rowPerPage + 1;
        if (this.profiles.length % this.rowPerPage == 0) {
            --this.total;
        }
        this.totalPage.setText("/" + this.total);
        this.targetPage.setText("" + (this.pageNum + 1));
        this.searchToTxt.setText(this.total > 300 ? "300" : "" + this.total);
        this.searchFromTxt.setText("1");
        this.maxCountTxt.setText("10000");
        if (isSummary) {
            this.summaryBtn.setEnabled(false);
        }
        this.adapter.setFileName(String.valueOf(TextProxy.object.getLoadText(date, this.p.objHash, serverId)) + "_ " + Hexa32.toString32((long)this.p.txid) + ".txt");
        this.setProfile();
    }

    public void setProfile() {
        this.setWidgets(true);
        this.text.setText("");
        int lastIdx = this.profiles[this.profiles.length - 1].getLastIndex();
        int length = Integer.toString(lastIdx).length();
        SaveProfileJob.setProfileData(this.p, this.profiles, this.text, this.pageNum, this.rowPerPage, this.prevBtn, this.nextBtn, this.startBtn, this.endBtn, length, this.serverId, this.searchLineIndex, this.isSummary);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    private StyleRange style(int start, int length, Color c, int f) {
        StyleRange t = new StyleRange();
        t.start = start;
        t.length = length;
        t.foreground = c;
        t.fontStyle = f;
        return t;
    }

    @Override
    public void setTableItem(TableItem t) {
    }

    @Override
    public void setChanges() {
    }

    public class ProfileSummary {
        String name;
        int callCnt;
        int sumResTime;
        int avgResTime;
        int type;

        public ProfileSummary(String name, int callCnt, int sumResTime, int avgResTime, int type) {
            this.name = name;
            this.callCnt = callCnt;
            this.sumResTime = sumResTime;
            this.avgResTime = avgResTime;
            this.type = type;
        }

        public void addResTime(int resTime) {
            ++this.callCnt;
            this.sumResTime += resTime;
            this.avgResTime = (int)Math.ceil((double)this.sumResTime / (double)this.callCnt);
        }

        public int getSortValue(int type) {
            if (type == 100) {
                return this.callCnt;
            }
            if (type == 200) {
                return this.sumResTime;
            }
            if (type == 300) {
                return this.avgResTime;
            }
            return this.callCnt;
        }
    }

    class ValueComparator
    implements Comparator<String> {
        Map<String, ProfileSummary> base;

        public ValueComparator(Map<String, ProfileSummary> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            if (this.base.get(a).getSortValue(XLogFullProfileView.this.CURRENT_SORT_CRITERIA) >= this.base.get(b).getSortValue(XLogFullProfileView.this.CURRENT_SORT_CRITERIA)) {
                return -1;
            }
            return 1;
        }
    }
}

