/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import java.io.IOException;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.model.AgentDailyListProxy;
import scouter.client.model.XLogData;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.CalendarDialog;
import scouter.client.popup.TimeRangeDialog;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.xlog.XLogUtil;
import scouter.client.xlog.actions.OpenXLogLoadTimeAction;
import scouter.client.xlog.views.XLogViewCommon;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.Value;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.ThreadUtil;

public class XLogLoadTimeView
extends XLogViewCommon
implements TimeRangeDialog.ITimeRange,
CalendarDialog.ILoadCalendarDialog {
    public static final String ID = XLogLoadTimeView.class.getName();
    long stime;
    long etime;
    private int serverId;
    LoadXLogJob loadJob;
    AgentDailyListProxy agnetProxy = new AgentDailyListProxy();

    @Override
    protected void openInExternalLink() {
        Program.launch((String)this.makeExternalUrl(this.serverId));
    }

    @Override
    protected void clipboardOfExternalLink() {
        Clipboard clipboard = new Clipboard(this.getViewSite().getShell().getDisplay());
        String linkUrl = this.makeExternalUrl(this.serverId);
        clipboard.setContents((Object[])new String[]{linkUrl}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    public void createPartControl(Composite parent) {
        this.display = Display.getCurrent();
        this.shell = new Shell(this.display);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        this.create(parent, man);
        man.add((IAction)new Action("zoom in", ImageUtil.getImageDescriptor(Images.zoomin)){

            public void run() {
                TimeRangeDialog dialog = new TimeRangeDialog(XLogLoadTimeView.this.display, XLogLoadTimeView.this, DateUtil.yyyymmdd((long)XLogLoadTimeView.this.stime));
                dialog.show(XLogLoadTimeView.this.stime, XLogLoadTimeView.this.etime);
            }
        });
        man.add((IAction)new Action("zoom out", ImageUtil.getImageDescriptor(Images.zoomout)){

            public void run() {
                if (XLogLoadTimeView.this.viewPainter.isZoomMode()) {
                    XLogLoadTimeView.this.viewPainter.endZoom();
                } else {
                    XLogLoadTimeView.this.viewPainter.keyPressed(16777261);
                    XLogLoadTimeView.this.viewPainter.build();
                }
                XLogLoadTimeView.this.canvas.redraw();
            }
        });
        man.add((IContributionItem)new Separator());
        new MenuItem(this.contextMenu, 2);
        MenuItem loadXLogItem = new MenuItem(this.contextMenu, 8);
        loadXLogItem.setText("Load History");
        loadXLogItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                new OpenXLogLoadTimeAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), XLogLoadTimeView.this.objType, Images.server, XLogLoadTimeView.this.serverId, XLogLoadTimeView.this.stime, XLogLoadTimeView.this.etime).run();
            }
        });
        this.canvas.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                XLogLoadTimeView.this.viewPainter.set(XLogLoadTimeView.this.canvas.getClientArea());
                XLogLoadTimeView.this.viewPainter.build();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void createContextMenu(Composite parent, IMenuListener listener) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(listener);
        Menu menu = contextMenu.createContextMenu((Control)parent);
        this.canvas.setMenu(menu);
    }

    public void refresh() {
        this.viewPainter.build();
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                XLogLoadTimeView.this.canvas.redraw();
            }
        });
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    public void setInput(long stime, long etime, String objType, int serverId) {
        this.stime = stime;
        this.etime = etime;
        this.objType = objType;
        this.serverId = serverId;
        this.setObjType(objType);
        this.viewPainter.setEndTime(etime);
        this.viewPainter.setTimeRange(etime - stime);
        String svrName = "";
        String objTypeDisplay = "";
        Server server = ServerManager.getInstance().getServer(serverId);
        if (server != null) {
            svrName = server.getName();
            objTypeDisplay = server.getCounterEngine().getDisplayNameObjectType(objType);
        }
        this.setPartName("XLog - " + objTypeDisplay);
        this.setContentDescription("\u24e2" + svrName + " | " + objTypeDisplay + "'s " + "XLog Pasttime" + " | " + DateUtil.format((long)stime, (String)"yyyy-MM-dd") + "(" + DateUtil.format((long)stime, (String)"HH:mm") + "~" + DateUtil.format((long)etime, (String)"HH:mm") + ")");
        this.setDate(DateUtil.yyyymmdd((long)stime));
        try {
            this.loadJob = new LoadXLogJob();
            this.loadJob.schedule();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)e.getMessage());
        }
    }

    @Override
    public void setTimeRange(long stime, long etime) {
        if (this.viewPainter.zoomIn(stime, etime)) {
            this.canvas.redraw();
        }
    }

    @Override
    public void setFocus() {
        super.setFocus();
        String statusMessage = "setInput(objType:" + this.objType + ", serverId:" + this.serverId + ", twdata size(): " + this.twdata.size() + ")";
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        slManager.setMessage(statusMessage);
    }

    @Override
    public void loadAdditinalData(long stime, long etime, final boolean reverse) {
        int max = this.getMaxCount();
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        try {
            try {
                MapPack param = new MapPack();
                String date = DateUtil.yyyymmdd((long)stime);
                param.put("date", date);
                param.put("stime", stime);
                param.put("etime", etime);
                param.put("objHash", (Value)this.agnetProxy.getObjHashLv(date, this.serverId, this.objType));
                param.put("reverse", (Value)new BooleanValue(reverse));
                int limit = PManager.getInstance().getInt("xlog_ignore_time");
                if (limit > 0) {
                    param.put("limit", (long)limit);
                }
                if (max > 0) {
                    param.put("max", (long)max);
                }
                this.twdata.setMax(max);
                tcp.process("TRANX_LOAD_TIME_GROUP", param, new INetReader(){

                    @Override
                    public void process(DataInputX in) throws IOException {
                        Pack p = in.readPack();
                        XLogPack x = XLogUtil.toXLogPack(p);
                        if (reverse) {
                            XLogLoadTimeView.this.twdata.putFirst(x.txid, (Object)new XLogData(x, XLogLoadTimeView.this.serverId));
                        } else {
                            XLogLoadTimeView.this.twdata.putLast(x.txid, (Object)new XLogData(x, XLogLoadTimeView.this.serverId));
                        }
                    }
                });
            }
            catch (Throwable t) {
                ConsoleProxy.errorSafe(t.toString());
                TcpProxy.putTcpProxy(tcp);
            }
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento = memento.createChild(ID);
        memento.putString("stime", String.valueOf(this.stime));
        memento.putString("etime", String.valueOf(this.etime));
        memento.putString("objType", this.objType);
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
        this.setInput(startTime, endTime, this.objType, this.serverId);
    }

    @Override
    public void onPressedOk(String date) {
    }

    @Override
    public void onPressedCancel() {
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.loadJob != null && (this.loadJob.getState() == 2 || this.loadJob.getState() == 4)) {
            this.loadJob.cancel();
        }
    }

    class LoadXLogJob
    extends Job {
        public LoadXLogJob() {
            super("XLog Loading...(" + DateUtil.format((long)XLogLoadTimeView.this.stime, (String)"yyyy-MM-dd") + " " + DateUtil.format((long)XLogLoadTimeView.this.stime, (String)"HH:mm") + "~" + DateUtil.format((long)XLogLoadTimeView.this.etime, (String)"HH:mm") + ")");
        }

        protected IStatus run(final IProgressMonitor monitor) {
            block7: {
                monitor.beginTask(String.valueOf(ServerManager.getInstance().getServer(XLogLoadTimeView.this.serverId).getName()) + "....", -1);
                int limit = PManager.getInstance().getInt("xlog_ignore_time");
                int max = XLogLoadTimeView.this.getMaxCount();
                TcpProxy tcp = TcpProxy.getTcpProxy(XLogLoadTimeView.this.serverId);
                try {
                    try {
                        XLogLoadTimeView.this.twdata.clear();
                        MapPack param = new MapPack();
                        String date = DateUtil.yyyymmdd((long)XLogLoadTimeView.this.stime);
                        param.put("date", date);
                        param.put("stime", XLogLoadTimeView.this.stime);
                        param.put("etime", XLogLoadTimeView.this.etime);
                        param.put("objHash", (Value)XLogLoadTimeView.this.agnetProxy.getObjHashLv(date, XLogLoadTimeView.this.serverId, XLogLoadTimeView.this.objType));
                        if (limit > 0) {
                            param.put("limit", (long)limit);
                        }
                        if (max > 0) {
                            param.put("max", (long)max);
                        }
                        ConsoleProxy.infoSafe("Load old XLog data");
                        ConsoleProxy.infoSafe("stime :" + FormatUtil.print((Object)new Date(XLogLoadTimeView.this.stime), (String)"yyyyMMdd HH:mm:ss.SSS"));
                        ConsoleProxy.infoSafe("etime :" + FormatUtil.print((Object)new Date(XLogLoadTimeView.this.etime), (String)"yyyyMMdd HH:mm:ss.SSS"));
                        ConsoleProxy.infoSafe("objType :" + XLogLoadTimeView.this.objType);
                        ConsoleProxy.infoSafe("limit :" + limit + "   max:" + max);
                        XLogLoadTimeView.this.twdata.setMax(max);
                        final BooleanValue refreshFlag = new BooleanValue(true);
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                while (refreshFlag.value) {
                                    XLogLoadTimeView.this.refresh();
                                    ThreadUtil.sleep((long)2000L);
                                }
                            }
                        }).start();
                        final DecimalValue count = new DecimalValue();
                        tcp.process("TRANX_LOAD_TIME_GROUP", param, new INetReader(){

                            @Override
                            public void process(DataInputX in) throws IOException {
                                Pack p = in.readPack();
                                if (monitor.isCanceled()) {
                                    throw new IOException("User cancelled");
                                }
                                XLogPack x = XLogUtil.toXLogPack(p);
                                ((LoadXLogJob)LoadXLogJob.this).XLogLoadTimeView.this.twdata.putLast(x.txid, (Object)new XLogData(x, ((LoadXLogJob)LoadXLogJob.this).XLogLoadTimeView.this.serverId));
                                ++count.value;
                                if (count.value % 10000L == 0L) {
                                    monitor.subTask(String.valueOf(count.value) + " XLog data received.");
                                }
                            }
                        });
                        refreshFlag.value = false;
                    }
                    catch (Throwable t) {
                        ConsoleProxy.errorSafe(t.toString());
                        TcpProxy.putTcpProxy(tcp);
                        monitor.done();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    monitor.done();
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
                monitor.done();
            }
            XLogLoadTimeView.this.refresh();
            return Status.OK_STATUS;
        }
    }
}

