/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Activator;
import scouter.client.Images;
import scouter.client.model.XLogData;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ImageUtil;
import scouter.client.xlog.ProfileText;
import scouter.client.xlog.SaveProfileJob;
import scouter.client.xlog.actions.OpenXLogProfileJob;
import scouter.client.xlog.actions.OpenXLogThreadProfileJob;
import scouter.client.xlog.dialog.XlogSummarySQLDialog;
import scouter.client.xlog.views.XLogFlowView;
import scouter.lang.step.Step;
import scouter.util.CacheTable;
import scouter.util.DateUtil;
import scouter.util.Hexa32;
import scouter.util.StringUtil;
import scouter.util.SystemUtil;

public class XLogProfileView
extends ViewPart {
    public static final String ID = XLogProfileView.class.getName();
    private StyledText text;
    private XLogData xLogData;
    private String txid;
    Menu contextMenu;
    MenuItem sqlSummary;
    MenuItem bindSqlParamMenu;
    MenuItem simplifiedProfileViewMenu;
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    Step[] steps;
    public static boolean isSummary;
    boolean truncated;
    private int serverId;
    boolean bindSqlParam;
    boolean isSimplified = true;
    CacheTable<String, Boolean> preventDupleEventTable = new CacheTable().setDefaultKeepTime(700L);
    Action openSqlSummaryDialog = new Action("SQL Statistics", ImageUtil.getImageDescriptor(Images.sum)){

        public void run() {
            XlogSummarySQLDialog summberSQLDialog = new XlogSummarySQLDialog(new Shell(Display.getDefault(), 3312), XLogProfileView.this.steps, XLogProfileView.this.xLogData);
            summberSQLDialog.open();
        }
    };
    Action saveFullProfile = new Action("Save Full Profile"){

        public void run() {
            SaveProfileJob job = new SaveProfileJob("Save Profile...", XLogProfileView.this.xLogData.p.endTime, XLogProfileView.this.xLogData, XLogProfileView.this.txid, XLogProfileView.this.serverId, isSummary);
            job.schedule();
        }
    };
    Action helpAction = new Action("help", ImageUtil.getImageDescriptor(Images.help)){

        public void run() {
            Program.launch((String)"https://github.com/scouter-project/scouter/blob/master/scouter.document/views/XLog-Profile-View.md");
        }
    };

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.text = new StyledText(composite, 2818);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.setText("");
        if (SystemUtil.IS_MAC_OSX) {
            this.text.setFont(new Font(null, "Courier New", 12, 0));
        } else {
            this.text.setFont(new Font(null, "Courier New", 10, 0));
        }
        this.text.setBackgroundImage(Activator.getImage("icons/grid.jpg"));
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)this.openSqlSummaryDialog);
        man.add((IAction)this.helpAction);
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)this.saveFullProfile);
        this.createContextMenu();
    }

    private void createContextMenu() {
        this.contextMenu = new Menu((Control)this.text);
        this.sqlSummary = new MenuItem(this.contextMenu, 8);
        this.sqlSummary.setText("SQL Statistics");
        this.sqlSummary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogProfileView.this.openSqlSummaryDialog.run();
            }
        });
        this.bindSqlParamMenu = new MenuItem(this.contextMenu, 32);
        this.bindSqlParamMenu.setText("Bind SQL Parameter");
        this.bindSqlParamMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogProfileView.this.bindSqlParam = XLogProfileView.this.bindSqlParamMenu.getSelection();
                XLogProfileView.this.setInput(XLogProfileView.this.steps, XLogProfileView.this.xLogData, XLogProfileView.this.serverId);
            }
        });
        this.simplifiedProfileViewMenu = new MenuItem(this.contextMenu, 32);
        this.simplifiedProfileViewMenu.setSelection(true);
        this.simplifiedProfileViewMenu.setText("Simplified Profile View");
        this.simplifiedProfileViewMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogProfileView.this.isSimplified = XLogProfileView.this.simplifiedProfileViewMenu.getSelection();
                XLogProfileView.this.setInput(XLogProfileView.this.steps, XLogProfileView.this.xLogData, XLogProfileView.this.serverId);
            }
        });
        MenuItem saveProfile = new MenuItem(this.contextMenu, 8);
        saveProfile.setText("Save Full Profile");
        saveProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogProfileView.this.saveFullProfile.run();
            }
        });
        this.text.setMenu(this.contextMenu);
    }

    public void setInput(Step[] steps, final XLogData item, int serverId) {
        this.steps = steps;
        this.xLogData = item;
        this.txid = Hexa32.toString32((long)item.p.txid);
        this.serverId = serverId;
        Server server = ServerManager.getInstance().getServer(serverId);
        this.sqlSummary.setEnabled(server.isAllowAction("AllowSqlParameter"));
        this.bindSqlParamMenu.setEnabled(server.isAllowAction("AllowSqlParameter"));
        this.setPartName(this.txid);
        this.text.setText("");
        ProfileText.build(DateUtil.yyyymmdd((long)this.xLogData.p.endTime), this.text, this.xLogData, steps, serverId, this.bindSqlParam, this.isSimplified);
        this.text.addListener(4, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleEvent(Event event) {
                try {
                    int line;
                    String fulltxt;
                    int offset = XLogProfileView.this.text.getOffsetAtLocation(new Point(event.x, event.y));
                    StyleRange style = XLogProfileView.this.text.getStyleRangeAtOffset(offset);
                    if (style == null || !style.underline || style.underlineStyle != 4 || !StringUtil.isNotEmpty((String)(fulltxt = XLogProfileView.this.text.getLine(line = XLogProfileView.this.text.getLineAtOffset(offset))))) return;
                    if (fulltxt.startsWith("\u25ba gxid")) {
                        if (XLogProfileView.this.preventDupleEventTable.get((Object)"gxid") != null) {
                            return;
                        }
                        CacheTable<String, Boolean> cacheTable = XLogProfileView.this.preventDupleEventTable;
                        synchronized (cacheTable) {
                            if (XLogProfileView.this.preventDupleEventTable.get((Object)"gxid") != null) {
                                return;
                            }
                            XLogProfileView.this.preventDupleEventTable.put((Object)"gxid", (Object)new Boolean(true));
                        }
                        String[] tokens = StringUtil.tokenizer((String)fulltxt, (String)" =\n");
                        String gxid = tokens[2];
                        try {
                            XLogFlowView view = (XLogFlowView)XLogProfileView.this.window.getActivePage().showView(XLogFlowView.ID, gxid, 1);
                            if (view == null) return;
                            view.loadByGxId(DateUtil.yyyymmdd((long)item.p.endTime), Hexa32.toLong32((String)gxid));
                            return;
                        }
                        catch (PartInitException e) {
                            ConsoleProxy.error(e.toString());
                        }
                        return;
                    }
                    if (fulltxt.startsWith("\u25ba txid")) {
                        if (XLogProfileView.this.preventDupleEventTable.get((Object)"txid") != null) {
                            return;
                        }
                        String[] tokens = XLogProfileView.this.preventDupleEventTable;
                        synchronized (XLogProfileView.this.preventDupleEventTable) {
                            if (XLogProfileView.this.preventDupleEventTable.get((Object)"txid") != null) {
                                // ** MonitorExit[tokens] (shouldn't be in output)
                                return;
                            }
                            XLogProfileView.this.preventDupleEventTable.put((Object)"txid", (Object)new Boolean(true));
                            // ** MonitorExit[tokens] (shouldn't be in output)
                            tokens = StringUtil.tokenizer((String)fulltxt, (String)" =\n");
                            String txid = tokens[tokens.length - 1];
                            try {
                                XLogFlowView view = (XLogFlowView)XLogProfileView.this.window.getActivePage().showView(XLogFlowView.ID, txid, 1);
                                if (view == null) return;
                                view.loadByTxId(DateUtil.yyyymmdd((long)item.p.endTime), Hexa32.toLong32((String)txid));
                                return;
                            }
                            catch (PartInitException e) {
                                ConsoleProxy.error(e.toString());
                            }
                            return;
                        }
                    }
                    if (fulltxt.startsWith("\u25ba caller")) {
                        if (XLogProfileView.this.preventDupleEventTable.get((Object)"caller") != null) {
                            return;
                        }
                        String[] tokens = XLogProfileView.this.preventDupleEventTable;
                        synchronized (XLogProfileView.this.preventDupleEventTable) {
                            if (XLogProfileView.this.preventDupleEventTable.get((Object)"caller") != null) {
                                // ** MonitorExit[tokens] (shouldn't be in output)
                                return;
                            }
                            XLogProfileView.this.preventDupleEventTable.put((Object)"caller", (Object)new Boolean(true));
                            // ** MonitorExit[tokens] (shouldn't be in output)
                            tokens = StringUtil.tokenizer((String)fulltxt, (String)" =\n");
                            String txIdStr = tokens[tokens.length - 1];
                            long txid = Hexa32.toLong32((String)txIdStr);
                            new OpenXLogProfileJob(XLogProfileView.this.getViewSite().getShell().getDisplay(), DateUtil.yyyymmdd((long)item.p.endTime), txid, item.p.gxid).schedule();
                            return;
                        }
                    }
                    if (fulltxt.endsWith(">") && fulltxt.contains("call:")) {
                        if (XLogProfileView.this.preventDupleEventTable.get((Object)"call") != null) {
                            return;
                        }
                        CacheTable<String, Boolean> tokens = XLogProfileView.this.preventDupleEventTable;
                        synchronized (tokens) {
                            if (XLogProfileView.this.preventDupleEventTable.get((Object)"call") != null) {
                                return;
                            }
                            XLogProfileView.this.preventDupleEventTable.put((Object)"call", (Object)new Boolean(true));
                        }
                        int startIndex = fulltxt.lastIndexOf("<");
                        if (startIndex <= -1) return;
                        int endIndex = fulltxt.lastIndexOf(">");
                        String txIdStr = fulltxt.substring(startIndex + 1, endIndex);
                        long txid = Hexa32.toLong32((String)txIdStr);
                        new OpenXLogProfileJob(XLogProfileView.this.getViewSite().getShell().getDisplay(), DateUtil.yyyymmdd((long)item.p.endTime), txid, item.p.gxid).schedule();
                        return;
                    }
                    if (!fulltxt.endsWith(">") || !fulltxt.contains("thread:")) return;
                    if (XLogProfileView.this.preventDupleEventTable.get((Object)"thread") != null) {
                        return;
                    }
                    CacheTable<String, Boolean> startIndex = XLogProfileView.this.preventDupleEventTable;
                    synchronized (startIndex) {
                        if (XLogProfileView.this.preventDupleEventTable.get((Object)"thread") != null) {
                            return;
                        }
                        XLogProfileView.this.preventDupleEventTable.put((Object)"thread", (Object)new Boolean(true));
                    }
                    int startIndex2 = fulltxt.lastIndexOf("<");
                    if (startIndex2 <= -1) return;
                    int endIndex = fulltxt.lastIndexOf(">");
                    String txIdStr = fulltxt.substring(startIndex2 + 1, endIndex);
                    long threadTxid = Hexa32.toLong32((String)txIdStr);
                    new OpenXLogThreadProfileJob(XLogProfileView.this.xLogData, threadTxid).schedule();
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        this.text.redraw();
    }

    public void setFocus() {
    }
}

