/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.model.AgentDailyListProxy;
import scouter.client.model.AgentModelThread;
import scouter.client.model.RefreshThread;
import scouter.client.model.XLogData;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.client.xlog.XLogUtil;
import scouter.client.xlog.actions.OpenSearchXLogDialogAction;
import scouter.client.xlog.actions.OpenXLogLoadTimeAction;
import scouter.client.xlog.views.XLogViewCommon;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class XLogRealTimeView
extends XLogViewCommon
implements RefreshThread.Refreshable {
    public static final String ID = XLogRealTimeView.class.getName();
    private RefreshThread thread;
    Action act;
    private MapPack param = new MapPack();
    int serverId;
    AgentModelThread agentThread = AgentModelThread.getInstance();
    AgentDailyListProxy agnetProxy = new AgentDailyListProxy();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
    }

    @Override
    protected void openInExternalLink() {
        Program.launch((String)this.makeExternalUrl(this.serverId));
    }

    @Override
    protected void clipboardOfExternalLink() {
        Clipboard clipboard = new Clipboard(this.getViewSite().getShell().getDisplay());
        String linkUrl = this.makeExternalUrl(this.serverId);
        clipboard.setContents((Object[])new String[]{linkUrl}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    public void createPartControl(Composite parent) {
        this.display = Display.getCurrent();
        this.shell = new Shell(this.display);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        this.create(parent, man);
        Action searchOpenAction = new Action("search", ImageUtil.getImageDescriptor(Images.search)){

            public void run() {
                new OpenSearchXLogDialogAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), XLogRealTimeView.this.serverId, XLogRealTimeView.this.objType).run();
            }
        };
        man.add((IAction)searchOpenAction);
        man.add((IContributionItem)new Separator());
        man.add((IAction)new Action("zoom in", ImageUtil.getImageDescriptor(Images.zoomin)){

            public void run() {
                XLogRealTimeView.this.viewPainter.keyPressed(16777259);
                XLogRealTimeView.this.viewPainter.build();
                XLogRealTimeView.this.canvas.redraw();
            }
        });
        man.add((IAction)new Action("zoom out", ImageUtil.getImageDescriptor(Images.zoomout)){

            public void run() {
                XLogRealTimeView.this.viewPainter.keyPressed(16777261);
                XLogRealTimeView.this.viewPainter.build();
                XLogRealTimeView.this.canvas.redraw();
            }
        });
        this.canvas.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                XLogRealTimeView.this.viewPainter.set(XLogRealTimeView.this.canvas.getClientArea());
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        new MenuItem(this.contextMenu, 2);
        MenuItem loadXLogItem = new MenuItem(this.contextMenu, 8);
        loadXLogItem.setText("Load History");
        loadXLogItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                new OpenXLogLoadTimeAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "Load XLog", XLogRealTimeView.this.objType, Images.server, XLogRealTimeView.this.serverId).run();
            }
        });
        MenuItem searchXLogItem = new MenuItem(this.contextMenu, 8);
        searchXLogItem.setText("Search");
        searchXLogItem.setImage(Images.find);
        searchXLogItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                new OpenSearchXLogDialogAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), XLogRealTimeView.this.serverId, XLogRealTimeView.this.objType).run();
            }
        });
        this.setObjType(this.objType);
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String svrName = "";
        String objTypeDisplay = "";
        if (server != null) {
            svrName = server.getName();
            objTypeDisplay = server.getCounterEngine().getDisplayNameObjectType(this.objType);
            this.viewPainter.setServerId(this.serverId);
        }
        this.setPartName("XLog - " + objTypeDisplay);
        this.setContentDescription("\u24e2" + svrName + " | " + objTypeDisplay + "'s " + "XLog Realtime");
        this.thread = new RefreshThread(this, 2000);
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objType:" + this.objType + ", serverId:" + this.serverId);
        this.thread.start();
    }

    @Override
    public void setFocus() {
        super.setFocus();
        String statusMessage = "setInput(objType:" + this.objType + ", serverId:" + this.serverId + ", twdata size(): " + this.twdata.size() + ")";
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        slManager.setMessage(statusMessage);
    }

    @Override
    public void refresh() {
        block6: {
            this.setDate(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(this.serverId)));
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            ListValue objHashLv = this.agentThread.getLiveObjHashLV(this.serverId, this.objType);
            if (objHashLv.size() > 0) {
                try {
                    try {
                        this.param.put("objHash", (Value)objHashLv);
                        int limit = PManager.getInstance().getInt("xlog_ignore_time");
                        this.param.put("limit", (long)limit);
                        this.twdata.setMax(this.getMaxCount());
                        tcp.process("TRANX_REAL_TIME_GROUP", this.param, new INetReader(){

                            @Override
                            public void process(DataInputX in) throws IOException {
                                Pack p = in.readPack();
                                if (p.getPackType() == 10) {
                                    XLogRealTimeView.this.param = (MapPack)p;
                                } else {
                                    XLogPack x = XLogUtil.toXLogPack(p);
                                    XLogRealTimeView.this.twdata.putLast(x.txid, (Object)new XLogData(x, XLogRealTimeView.this.serverId));
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        ConsoleProxy.errorSafe(e.toString());
                        TcpProxy.putTcpProxy(tcp);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
        }
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                XLogRealTimeView.this.viewPainter.build();
                ExUtil.exec((Composite)XLogRealTimeView.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        (this).XLogRealTimeView.this.canvas.redraw();
                    }
                });
            }
        });
    }

    @Override
    public void loadAdditinalData(long stime, long etime, final boolean reverse) {
        this.viewPainter.setViewIsInAdditionalDataLoading(true);
        int max = this.getMaxCount();
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        try {
            try {
                MapPack param = new MapPack();
                String date = DateUtil.yyyymmdd((long)stime);
                param.put("date", date);
                param.put("stime", stime);
                param.put("etime", etime);
                param.put("objHash", (Value)this.agnetProxy.getObjHashLv(date, this.serverId, this.objType));
                param.put("reverse", (Value)new BooleanValue(reverse));
                int limit = PManager.getInstance().getInt("xlog_ignore_time");
                if (limit > 0) {
                    param.put("limit", (long)limit);
                }
                if (max > 0) {
                    param.put("max", (long)max);
                }
                this.twdata.setMax(max);
                tcp.process("TRANX_LOAD_TIME_GROUP", param, new INetReader(){

                    @Override
                    public void process(DataInputX in) throws IOException {
                        Pack p = in.readPack();
                        XLogPack x = XLogUtil.toXLogPack(p);
                        if (reverse) {
                            XLogRealTimeView.this.twdata.putFirst(x.txid, (Object)new XLogData(x, XLogRealTimeView.this.serverId));
                        } else {
                            XLogRealTimeView.this.twdata.putLast(x.txid, (Object)new XLogData(x, XLogRealTimeView.this.serverId));
                        }
                    }
                });
            }
            catch (Throwable t) {
                ConsoleProxy.errorSafe(t.toString());
                this.viewPainter.setViewIsInAdditionalDataLoading(false);
                TcpProxy.putTcpProxy(tcp);
            }
        }
        finally {
            this.viewPainter.setViewIsInAdditionalDataLoading(false);
            TcpProxy.putTcpProxy(tcp);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }
}

