/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.sorter.TableLabelSorter;
import scouter.client.util.ClientFileUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.xlog.actions.OpenXLogProfileJob;
import scouter.client.xlog.views.XLogColumnEnum;
import scouter.lang.CountryCode;
import scouter.util.FormatUtil;
import scouter.util.Hexa32;
import scouter.util.IPUtil;
import scouter.util.StringUtil;

public class XLogSelectionView
extends ViewPart {
    public static final String ID = XLogSelectionView.class.getName();
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;
    private String yyyymmdd;
    private Clipboard clipboard;
    ArrayList<XLogColumnEnum> columnList = new ArrayList();

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite comp = new Composite(parent, 0);
        this.tableColumnLayout = new TableColumnLayout();
        comp.setLayout((Layout)this.tableColumnLayout);
        this.viewer = new TableViewer(comp, 68352);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new TableLabelSorter(this.viewer));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)XLogSelectionView.this.viewer.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof XLogData) {
                    XLogData data = (XLogData)o;
                    Display display = XLogSelectionView.this.getViewSite().getShell().getDisplay();
                    new OpenXLogProfileJob(display, data, data.serverId).schedule();
                } else {
                    System.out.println(o);
                }
            }
        });
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Copy to clipboard", ImageUtil.getImageDescriptor(Images.copy)){

            public void run() {
                XLogSelectionView.this.copyToClipboard();
            }
        });
        this.clipboard = new Clipboard(null);
        this.getSite().getPage().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
                XLogSelectionView.this.saveColumnsInfo();
            }
        });
    }

    public void setInput(ArrayList<XLogData> xperfData, String objType, String yyyymmdd) {
        this.yyyymmdd = yyyymmdd;
        Server server = ServerManager.getInstance().getServer(xperfData.get((int)0).serverId);
        String objTypeDisplay = "";
        if (server != null) {
            objTypeDisplay = server.getCounterEngine().getDisplayNameObjectType(objType);
        }
        this.setPartName(String.valueOf(objTypeDisplay) + " - " + "XLog List");
        this.viewer.setInput(xperfData);
    }

    private void createColumns() {
        XLogColumnStore columnStore = this.loadColumnInfo();
        if (columnStore != null && columnStore.getColumns() != null && this.isTheSameXLogColumnEnum(columnStore.getColumns())) {
            columnStore.getColumns().stream().forEach(column -> {
                if (PManager.getInstance().getBoolean(column.getInternalID())) {
                    this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
                    this.columnList.add((XLogColumnEnum)column);
                }
            });
        } else {
            XLogColumnEnum[] xLogColumnEnumArray = XLogColumnEnum.values();
            int n = xLogColumnEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                XLogColumnEnum column2 = xLogColumnEnumArray[n2];
                if (PManager.getInstance().getBoolean(column2.getInternalID())) {
                    this.createTableViewerColumn(column2.getTitle(), column2.getWidth(), column2.getAlignment(), column2.isResizable(), column2.isMoveable(), column2.isNumber());
                    this.columnList.add(column2);
                }
                ++n2;
            }
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableItemProvider());
    }

    private boolean isTheSameXLogColumnEnum(List<XLogColumnEnum> loadedColummEnumList) {
        XLogColumnEnum[] xLogColumnEnumArray = XLogColumnEnum.values();
        int n = xLogColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            XLogColumnEnum xLogColumn = xLogColumnEnumArray[n2];
            boolean visible = PManager.getInstance().getBoolean(xLogColumn.getInternalID());
            if (visible && !loadedColummEnumList.contains(xLogColumn)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void saveColumnsInfo() {
        XLogColumnStore columnStore = new XLogColumnStore();
        try {
            Table table = this.viewer.getTable();
            int[] columnOrders = table.getColumnOrder();
            TableColumn[] columns = table.getColumns();
            int i = 0;
            while (i < columnOrders.length) {
                TableColumn column = columns[columnOrders[i]];
                XLogColumnEnum columnEnum = XLogColumnEnum.findByTitle(column.getText());
                columnEnum.setWidth(column.getWidth());
                columnStore.addColumn(columnEnum);
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (columnStore.getColumns().size() > 0) {
            ExUtil.asyncRun(() -> {
                boolean bl = ClientFileUtil.saveObjectFile(columnStore, "xlogcolumnfile");
            });
        }
    }

    private XLogColumnStore loadColumnInfo() {
        XLogColumnStore store = null;
        try {
            store = ClientFileUtil.readObjectFile("xlogcolumnfile", XLogColumnStore.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (store != null && store.getColumns().size() == 0) {
            store = null;
        }
        return store;
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableLabelSorter sorter = (TableLabelSorter)XLogSelectionView.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    private void copyToClipboard() {
        if (this.viewer != null) {
            TableItem[] items = this.viewer.getTable().getItems();
            int colCnt = this.viewer.getTable().getColumnCount();
            if (items != null && items.length > 0) {
                StringBuffer sb = new StringBuffer();
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    int i = 0;
                    while (i < colCnt) {
                        String value = item.getText(i);
                        value = value.replace("\n", "[\\n]");
                        value = value.replace("\t", "    ");
                        sb.append(value);
                        if (i == colCnt - 1) {
                            sb.append("\n");
                        } else {
                            sb.append("\t");
                        }
                        ++i;
                    }
                    ++n2;
                }
                this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
                MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Copy", (String)"Copied to clipboard");
            }
        }
    }

    public void dispose() {
        this.clipboard.dispose();
        super.dispose();
    }

    public void setFocus() {
    }

    class TableItemProvider
    implements ITableLabelProvider,
    IColorProvider {
        TableItemProvider() {
        }

        public Color getForeground(Object element) {
            if (element instanceof XLogData) {
                XLogData d = (XLogData)element;
                if (d.p.error != 0) {
                    if (d.p.xType == 3 || d.p.xType == 4) {
                        return ColorUtil.getInstance().getColor("light red");
                    }
                    return ColorUtil.getInstance().getColor("red");
                }
                if (d.p.xType == 3 || d.p.xType == 4) {
                    return ColorUtil.getInstance().getColor("light gray");
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof XLogData)) {
                return null;
            }
            XLogData d = (XLogData)element;
            XLogColumnEnum column = XLogSelectionView.this.columnList.get(columnIndex);
            switch (column) {
                case OBJECT: {
                    if (StringUtil.isEmpty((String)d.objName)) {
                        d.objName = TextProxy.object.getLoadText(XLogSelectionView.this.yyyymmdd, d.p.objHash, d.serverId);
                    }
                    return d.objName;
                }
                case ELAPSED: {
                    return FormatUtil.print((Object)d.p.elapsed, (String)"#,##0");
                }
                case SERVICE: {
                    if (StringUtil.isEmpty((String)d.serviceName)) {
                        d.serviceName = TextProxy.service.getLoadText(XLogSelectionView.this.yyyymmdd, d.p.service, d.serverId);
                    }
                    return d.serviceName;
                }
                case START_TIME: {
                    return FormatUtil.print((Object)new Date(d.p.endTime - (long)d.p.elapsed), (String)"HH:mm:ss.SSS");
                }
                case END_TIME: {
                    return FormatUtil.print((Object)new Date(d.p.endTime), (String)"HH:mm:ss.SSS");
                }
                case TX_ID: {
                    return Hexa32.toString32((long)d.p.txid);
                }
                case CPU: {
                    return FormatUtil.print((Object)d.p.cpu, (String)"#,##0");
                }
                case SQL_COUNT: {
                    return FormatUtil.print((Object)d.p.sqlCount, (String)"#,##0");
                }
                case SQL_TIME: {
                    return FormatUtil.print((Object)d.p.sqlTime, (String)"#,##0");
                }
                case API_COUNT: {
                    return FormatUtil.print((Object)d.p.apicallCount, (String)"#,##0");
                }
                case API_TIME: {
                    return FormatUtil.print((Object)d.p.apicallTime, (String)"#,##0");
                }
                case KBYTES: {
                    return FormatUtil.print((Object)d.p.kbytes, (String)"#,##0");
                }
                case IP: {
                    return IPUtil.toString((byte[])d.p.ipaddr);
                }
                case ERROR: {
                    return d.p.error == 0 ? "" : TextProxy.error.getLoadText(XLogSelectionView.this.yyyymmdd, d.p.error, d.serverId);
                }
                case GX_ID: {
                    return Hexa32.toString32((long)d.p.gxid);
                }
                case LOGIN: {
                    return d.p.login != 0 ? TextProxy.login.getLoadText(XLogSelectionView.this.yyyymmdd, d.p.login, d.serverId) : null;
                }
                case DESC: {
                    return d.p.desc != 0 ? TextProxy.desc.getLoadText(XLogSelectionView.this.yyyymmdd, d.p.desc, d.serverId) : null;
                }
                case TEXT1: {
                    return d.p.text1;
                }
                case TEXT2: {
                    return d.p.text2;
                }
                case TEXT3: {
                    return d.p.text3;
                }
                case TEXT4: {
                    return d.p.text4;
                }
                case TEXT5: {
                    return d.p.text5;
                }
                case DUMP: {
                    return d.p.hasDump == 1 ? "Y" : null;
                }
                case UA: {
                    return d.p.userAgent != 0 ? TextProxy.userAgent.getLoadText(XLogSelectionView.this.yyyymmdd, d.p.userAgent, d.serverId) : null;
                }
                case COUNTRY: {
                    return StringUtil.isNotEmpty((String)d.p.countryCode) ? CountryCode.getCountryName((String)d.p.countryCode) : null;
                }
                case CITY: {
                    return d.p.city != 0 ? TextProxy.city.getLoadText(XLogSelectionView.this.yyyymmdd, d.p.city, d.serverId) : null;
                }
                case GROUP: {
                    return d.p.group != 0 ? TextProxy.group.getLoadText(XLogSelectionView.this.yyyymmdd, d.p.group, d.serverId) : null;
                }
            }
            return null;
        }
    }

    public static class XLogColumnStore
    implements Serializable {
        private static final long serialVersionUID = -1477341833801636951L;
        private List<XLogColumnEnum> columns = new ArrayList<XLogColumnEnum>();
        private List<Integer> widthsForSerialization = new ArrayList<Integer>();

        public void addColumn(XLogColumnEnum xLogColumnEnum) {
            this.columns.add(xLogColumnEnum);
            this.widthsForSerialization.add(xLogColumnEnum.getWidth());
        }

        public void setColumns(ArrayList<XLogColumnEnum> xLogColumnEnums) {
            this.columns = xLogColumnEnums;
        }

        public List<XLogColumnEnum> getColumns() {
            try {
                IntStream.range(0, this.columns.size()).forEach(index -> this.columns.get(index).setWidth(this.widthsForSerialization.get(index)));
            }
            catch (Throwable t) {
                return new ArrayList<XLogColumnEnum>();
            }
            return this.columns;
        }
    }
}

