/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Activator;
import scouter.client.model.XLogData;
import scouter.client.xlog.ProfileText;
import scouter.client.xlog.actions.OpenXLogProfileJob;
import scouter.client.xlog.actions.OpenXLogThreadProfileJob;
import scouter.lang.step.Step;
import scouter.util.DateUtil;
import scouter.util.Hexa32;
import scouter.util.StringUtil;
import scouter.util.SystemUtil;

public class XLogThreadProfileView
extends ViewPart {
    public static final String ID = XLogThreadProfileView.class.getName();
    private StyledText text;
    private String date;
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    Step[] steps;

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.text = new StyledText(composite, 2818);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.setText("");
        if (SystemUtil.IS_MAC_OSX) {
            this.text.setFont(new Font(null, "Courier New", 12, 0));
        } else {
            this.text.setFont(new Font(null, "Courier New", 10, 0));
        }
        this.text.setBackgroundImage(Activator.getImage("icons/grid.jpg"));
    }

    public void setInput(final XLogData data, Step[] steps, long threadId, int serverId) {
        this.date = DateUtil.yyyymmdd((long)data.p.endTime);
        this.steps = steps;
        this.setPartName(Hexa32.toString32((long)threadId));
        this.text.setText("");
        ProfileText.buildThreadProfile(data, this.text, steps);
        this.text.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                try {
                    int line;
                    String fulltxt;
                    int offset = XLogThreadProfileView.this.text.getOffsetAtLocation(new Point(event.x, event.y));
                    StyleRange style = XLogThreadProfileView.this.text.getStyleRangeAtOffset(offset);
                    if (style != null && style.underline && style.underlineStyle == 4 && StringUtil.isNotEmpty((String)(fulltxt = XLogThreadProfileView.this.text.getLine(line = XLogThreadProfileView.this.text.getLineAtOffset(offset))))) {
                        int startIndex;
                        if (fulltxt.endsWith(">") && fulltxt.contains("call:")) {
                            int startIndex2 = fulltxt.lastIndexOf("<");
                            if (startIndex2 > -1) {
                                int endIndex = fulltxt.lastIndexOf(">");
                                String txIdStr = fulltxt.substring(startIndex2 + 1, endIndex);
                                long txid = Hexa32.toLong32((String)txIdStr);
                                new OpenXLogProfileJob(XLogThreadProfileView.this.getViewSite().getShell().getDisplay(), XLogThreadProfileView.this.date, txid, data.p.gxid).schedule();
                            }
                        } else if (fulltxt.endsWith(">") && fulltxt.contains("thread:") && (startIndex = fulltxt.lastIndexOf("<")) > -1) {
                            int endIndex = fulltxt.lastIndexOf(">");
                            String txIdStr = fulltxt.substring(startIndex + 1, endIndex);
                            long threadTxid = Hexa32.toLong32((String)txIdStr);
                            new OpenXLogThreadProfileJob(data, threadTxid).schedule();
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    public static void main(String[] args) {
        String fulltxt = "call: UCON:http://127.0.0.1:8080/e2end.jsp 117 ms <z2bcfcg3hfcm0h>";
        int startIndex = fulltxt.lastIndexOf("<");
        if (startIndex > -1) {
            int endIndex = fulltxt.lastIndexOf(">");
            String txIdStr = fulltxt.substring(startIndex + 1, endIndex);
            System.out.println(txIdStr);
        }
    }
}

