/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.AgentModelThread;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.xlog.XLogFilterStatus;
import scouter.client.xlog.XLogYAxisEnum;
import scouter.client.xlog.dialog.XLogFilterDialog;
import scouter.client.xlog.dialog.XLogSummaryIPDialog;
import scouter.client.xlog.dialog.XLogSummaryRefererDialog;
import scouter.client.xlog.dialog.XLogSummaryServiceDialog;
import scouter.client.xlog.dialog.XLogSummaryUserAgentDialog;
import scouter.client.xlog.dialog.XLogSummaryUserDialog;
import scouter.client.xlog.views.XLogSnapshotData;
import scouter.client.xlog.views.XLogViewMouse;
import scouter.client.xlog.views.XLogViewPainter;
import scouter.util.LongKeyLinkedMap;
import scouter.util.StringUtil;

public abstract class XLogViewCommon
extends ViewPart
implements XLogViewPainter.ITimeChange,
ObjectSelectManager.IObjectCheckListener {
    protected XLogViewPainter viewPainter;
    protected XLogViewMouse mouse;
    protected Canvas canvas;
    protected LongKeyLinkedMap<XLogData> twdata = new LongKeyLinkedMap();
    protected String objType;
    public String yyyymmdd;
    long lastRedraw = 0L;
    XLogFilterDialog filterDialog;
    XLogFilterStatus filterStatus = new XLogFilterStatus();
    XLogSummaryServiceDialog summaryServiceDialog;
    XLogSummaryIPDialog summaryIpDialog;
    XLogSummaryUserAgentDialog summaryUserAgentDialog;
    XLogSummaryRefererDialog summaryRefererDialog;
    XLogSummaryUserDialog summaryUserDialog;
    Menu contextMenu;
    protected MenuItem onlySqlItem;
    protected MenuItem onlyApiCallItem;
    protected MenuItem onlyErrorItem;
    protected Display display;
    protected Shell shell;
    protected ToolTip toolTip;
    Action onlySqlAction;
    Action onlyApicallAction;
    Action onlyErrorAction;
    Action helpAction;
    ObjectSelectManager objSelMgr = ObjectSelectManager.getInstance();

    protected abstract void openInExternalLink();

    protected abstract void clipboardOfExternalLink();

    protected String makeExternalUrl(int serverId) {
        Server server = ServerManager.getInstance().getServer(serverId);
        String linkName = server.getExtLinkName();
        String linkUrl = server.getExtLinkUrlPattern();
        String objHashes = AgentModelThread.getInstance().getLiveObjectHashStringWithParent(serverId, this.objType);
        if (StringUtil.isEmpty((String)objHashes)) {
            return "";
        }
        String from = this.viewPainter.lastDrawTimeStart > 0L ? String.valueOf(this.viewPainter.lastDrawTimeStart) : String.valueOf(System.currentTimeMillis() - 300000L);
        String to = this.viewPainter.lastDrawTimeStart > 0L ? String.valueOf(this.viewPainter.lastDrawTimeEnd) : String.valueOf(System.currentTimeMillis());
        linkUrl = linkUrl.replace("$[objHashes]", objHashes);
        linkUrl = linkUrl.replace("$[from]", from);
        linkUrl = linkUrl.replace("$[to]", to);
        linkUrl = linkUrl.replace("$[objType]", this.objType);
        return linkUrl;
    }

    public void create(Composite parent, IToolBarManager man) {
        this.helpAction = new Action("help", ImageUtil.getImageDescriptor(Images.help)){

            public void run() {
                Program.launch((String)"https://github.com/scouter-project/scouter/blob/master/scouter.document/views/XLog-View.md");
            }
        };
        man.add((IAction)this.helpAction);
        man.add((IContributionItem)new Separator());
        Action filterOpenAction = new Action("filter", ImageUtil.getImageDescriptor(Images.filter)){

            public void run() {
                XLogViewCommon.this.filterDialog.setStatus(XLogViewCommon.this.filterStatus);
                XLogViewCommon.this.filterDialog.open();
            }
        };
        man.add((IAction)filterOpenAction);
        man.add((IContributionItem)new Separator());
        this.onlySqlAction = new Action("Only SQL", 2){

            public void run() {
                XLogViewCommon.this.filterStatus.onlySql = this.isChecked();
                XLogViewCommon.this.onlySqlItem.setSelection(this.isChecked());
                XLogViewCommon.this.setFilter(XLogViewCommon.this.filterStatus);
            }
        };
        this.onlySqlAction.setImageDescriptor(ImageUtil.getImageDescriptor(Images.database_go));
        man.add((IAction)this.onlySqlAction);
        this.onlyApicallAction = new Action("Only ApiCall", 2){

            public void run() {
                XLogViewCommon.this.filterStatus.onlyApicall = this.isChecked();
                XLogViewCommon.this.onlyApiCallItem.setSelection(this.isChecked());
                XLogViewCommon.this.setFilter(XLogViewCommon.this.filterStatus);
            }
        };
        this.onlyApicallAction.setImageDescriptor(ImageUtil.getImageDescriptor(Images.link));
        man.add((IAction)this.onlyApicallAction);
        this.onlyErrorAction = new Action("Only Error", 2){

            public void run() {
                XLogViewCommon.this.filterStatus.onlyError = this.isChecked();
                XLogViewCommon.this.onlyErrorItem.setSelection(this.isChecked());
                XLogViewCommon.this.setFilter(XLogViewCommon.this.filterStatus);
            }
        };
        this.onlyErrorAction.setImageDescriptor(ImageUtil.getImageDescriptor(Images.error));
        man.add((IAction)this.onlyErrorAction);
        man.add((IContributionItem)new Separator());
        this.canvas = new Canvas(parent, 0x20000000);
        this.canvas.setLayout((Layout)new GridLayout());
        this.mouse = new XLogViewMouse(this.twdata, this.canvas);
        this.viewPainter = new XLogViewPainter(this.twdata, this.mouse, this);
        this.viewPainter.set(this.canvas.getClientArea());
        this.mouse.setPainter(this.viewPainter);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                try {
                    XLogViewCommon.this.viewPainter.drawImageBuffer(e.gc);
                    XLogViewCommon.this.viewPainter.drawSelectArea(e.gc);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)this.mouse);
        this.canvas.addMouseMoveListener((MouseMoveListener)this.mouse);
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                final int key = e.keyCode;
                ExUtil.asyncRun(new Runnable(){

                    @Override
                    public void run() {
                        (this).XLogViewCommon.this.viewPainter.keyPressed(key);
                        (this).XLogViewCommon.this.viewPainter.build();
                        ExUtil.exec((Composite)(this).XLogViewCommon.this.canvas, new Runnable(){

                            @Override
                            public void run() {
                                ((this).this).XLogViewCommon.this.canvas.redraw();
                            }
                        });
                    }
                });
            }
        });
        this.filterDialog = new XLogFilterDialog(this);
        this.summaryServiceDialog = new XLogSummaryServiceDialog(this.getViewSite().getShell().getDisplay(), this.twdata);
        this.summaryIpDialog = new XLogSummaryIPDialog(this.getViewSite().getShell().getDisplay(), this.twdata);
        this.summaryUserAgentDialog = new XLogSummaryUserAgentDialog(this.getViewSite().getShell().getDisplay(), this.twdata);
        this.summaryRefererDialog = new XLogSummaryRefererDialog(this.getViewSite().getShell().getDisplay(), this.twdata);
        this.summaryUserDialog = new XLogSummaryUserDialog(this.getViewSite().getShell().getDisplay(), this.twdata);
        this.createContextMenu();
        ObjectSelectManager.getInstance().addObjectCheckStateListener(this);
    }

    private void createContextMenu() {
        this.contextMenu = new Menu((Control)this.canvas);
        MenuItem filterItem = new MenuItem(this.contextMenu, 64);
        filterItem.setText("Filter");
        Menu filterMenu = new Menu(this.contextMenu);
        filterItem.setMenu(filterMenu);
        MenuItem detailFilterItem = new MenuItem(filterMenu, 8);
        detailFilterItem.setText("&Open Filter Dialog");
        detailFilterItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogViewCommon.this.filterDialog.setStatus(XLogViewCommon.this.filterStatus);
                XLogViewCommon.this.filterDialog.open();
            }
        });
        new MenuItem(filterMenu, 2);
        this.onlySqlItem = new MenuItem(filterMenu, 32);
        this.onlySqlItem.setText("SQL");
        this.onlySqlItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XLogViewCommon.this.onlySqlAction.setChecked(XLogViewCommon.this.onlySqlItem.getSelection());
                XLogViewCommon.this.onlySqlAction.run();
            }
        });
        this.onlyApiCallItem = new MenuItem(filterMenu, 32);
        this.onlyApiCallItem.setText("API Call");
        this.onlyApiCallItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XLogViewCommon.this.onlyApicallAction.setChecked(XLogViewCommon.this.onlyApiCallItem.getSelection());
                XLogViewCommon.this.onlyApicallAction.run();
            }
        });
        this.onlyErrorItem = new MenuItem(filterMenu, 32);
        this.onlyErrorItem.setText("Error");
        this.onlyErrorItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XLogViewCommon.this.onlyErrorAction.setChecked(XLogViewCommon.this.onlyErrorItem.getSelection());
                XLogViewCommon.this.onlyErrorAction.run();
            }
        });
        MenuItem yAxisItem = new MenuItem(this.contextMenu, 64);
        yAxisItem.setText("Y Axis");
        Menu yAxisMenu = new Menu(this.contextMenu);
        yAxisItem.setMenu(yAxisMenu);
        XLogYAxisEnum[] xLogYAxisEnumArray = XLogYAxisEnum.values();
        int n = xLogYAxisEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            final XLogYAxisEnum yaxis = xLogYAxisEnumArray[n2];
            MenuItem item = new MenuItem(yAxisMenu, 16);
            item.setText(yaxis.getName());
            item.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    XLogViewCommon.this.viewPainter.setYAxisMode(yaxis);
                    XLogViewCommon.this.viewPainter.build();
                    XLogViewCommon.this.canvas.redraw();
                }
            });
            if (yaxis.isDefault()) {
                item.setSelection(true);
                item.notifyListeners(13, new Event());
            }
            ++n2;
        }
        new MenuItem(filterMenu, 2);
        MenuItem extLinkItem = new MenuItem(this.contextMenu, 64);
        extLinkItem.setText("Open in 3rd-party UI");
        Menu extLinkMenu = new Menu(this.contextMenu);
        extLinkItem.setMenu(extLinkMenu);
        MenuItem openExternal = new MenuItem(extLinkMenu, 8);
        openExternal.setText("Open in 3rd party UI");
        openExternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogViewCommon.this.openInExternalLink();
            }
        });
        MenuItem copyExternal = new MenuItem(extLinkMenu, 8);
        copyExternal.setText("Copy to clip board for 3rd party UI");
        copyExternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogViewCommon.this.clipboardOfExternalLink();
            }
        });
        new MenuItem(this.contextMenu, 2);
        MenuItem summaryItem = new MenuItem(this.contextMenu, 64);
        summaryItem.setText("Summary");
        Menu summaryMenu = new Menu(this.contextMenu);
        summaryItem.setMenu(summaryMenu);
        MenuItem serviceSummary = new MenuItem(summaryMenu, 8);
        serviceSummary.setText("Service");
        serviceSummary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long etime = XLogViewCommon.this.viewPainter.getLastTime();
                long stime = etime - XLogViewCommon.this.viewPainter.getTimeRange();
                XLogViewCommon.this.summaryServiceDialog.setRange(stime, etime);
                XLogViewCommon.this.summaryServiceDialog.show();
            }
        });
        MenuItem ipSummary = new MenuItem(summaryMenu, 8);
        ipSummary.setText("IP");
        ipSummary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long etime = XLogViewCommon.this.viewPainter.getLastTime();
                long stime = etime - XLogViewCommon.this.viewPainter.getTimeRange();
                XLogViewCommon.this.summaryIpDialog.setRange(stime, etime);
                XLogViewCommon.this.summaryIpDialog.show();
            }
        });
        MenuItem userAgentSummary = new MenuItem(summaryMenu, 8);
        userAgentSummary.setText("User-Agent");
        userAgentSummary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long etime = XLogViewCommon.this.viewPainter.getLastTime();
                long stime = etime - XLogViewCommon.this.viewPainter.getTimeRange();
                XLogViewCommon.this.summaryUserAgentDialog.setRange(stime, etime);
                XLogViewCommon.this.summaryUserAgentDialog.show();
            }
        });
        MenuItem refererSummary = new MenuItem(summaryMenu, 8);
        refererSummary.setText("Referer");
        refererSummary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long etime = XLogViewCommon.this.viewPainter.getLastTime();
                long stime = etime - XLogViewCommon.this.viewPainter.getTimeRange();
                XLogViewCommon.this.summaryRefererDialog.setRange(stime, etime);
                XLogViewCommon.this.summaryRefererDialog.show();
            }
        });
        MenuItem userSummary = new MenuItem(summaryMenu, 8);
        userSummary.setText("User");
        userSummary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long etime = XLogViewCommon.this.viewPainter.getLastTime();
                long stime = etime - XLogViewCommon.this.viewPainter.getTimeRange();
                XLogViewCommon.this.summaryUserDialog.setRange(stime, etime);
                XLogViewCommon.this.summaryUserDialog.show();
            }
        });
        this.canvas.setMenu(this.contextMenu);
    }

    public int getMaxCount() {
        return PManager.getInstance().getInt("xlog_max_count");
    }

    public void setObjType(String objType) {
        this.mouse.setObjType(objType);
    }

    public void setDate(String yyyymmdd) {
        this.yyyymmdd = yyyymmdd;
        this.viewPainter.yyyymmdd = yyyymmdd;
        this.mouse.yyyymmdd = yyyymmdd;
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        ObjectSelectManager.getInstance().removeObjectCheckStateListener(this);
        if (this.viewPainter != null) {
            this.viewPainter.dispose();
        }
        this.twdata.clear();
    }

    public String[] getExistObjNames() {
        if (this.twdata == null) {
            return new String[0];
        }
        HashSet<String> objNames = new HashSet<String>();
        Enumeration en = this.twdata.values();
        while (en.hasMoreElements()) {
            XLogData data = (XLogData)en.nextElement();
            String objName = data.objName;
            if (objName == null) {
                objName = TextProxy.object.getLoadText(this.yyyymmdd, data.p.objHash, data.serverId);
            }
            objNames.add(objName);
        }
        return objNames.toArray(new String[objNames.size()]);
    }

    @Override
    public void timeRangeChanged(long time_start, long time_end) {
        XLogData first = (XLogData)this.twdata.getFirstValue();
        XLogData last = (XLogData)this.twdata.getLastValue();
        if (first == null || last == null) {
            this.loadAdditinalData(time_start, time_end, false);
        } else if (first.p.endTime > time_end) {
            this.loadAdditinalData(time_start, time_end, true);
        } else if (last.p.endTime < time_start) {
            this.loadAdditinalData(time_start, time_end, false);
        } else {
            long firstTime = first.p.endTime;
            long lastTime = last.p.endTime;
            if (firstTime >= time_start && firstTime <= time_end) {
                this.loadAdditinalData(time_start, firstTime, true);
            }
            if (lastTime >= time_start && lastTime <= time_end) {
                this.loadAdditinalData(lastTime, time_end, false);
            }
        }
    }

    public abstract void loadAdditinalData(long var1, long var3, boolean var5);

    @Override
    public void notifyChangeState() {
        this.viewPainter.build();
        this.canvas.redraw();
    }

    public void setFilter(XLogFilterStatus filter) {
        this.filterStatus = filter;
        this.onlySqlAction.setChecked(this.filterStatus.onlySql);
        this.onlySqlItem.setSelection(this.filterStatus.onlySql);
        this.onlyApicallAction.setChecked(this.filterStatus.onlyApicall);
        this.onlyApiCallItem.setSelection(this.filterStatus.onlyApicall);
        this.onlyErrorAction.setChecked(this.filterStatus.onlyError);
        this.onlyErrorItem.setSelection(this.filterStatus.onlyError);
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                XLogViewCommon.this.viewPainter.setFilterStatus(XLogViewCommon.this.filterStatus);
                XLogViewCommon.this.viewPainter.build();
                ExUtil.exec((Composite)XLogViewCommon.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        (this).XLogViewCommon.this.canvas.redraw();
                    }
                });
            }
        });
    }

    static class CountComparator
    implements Comparator<XLogSnapshotData> {
        CountComparator() {
        }

        @Override
        public int compare(XLogSnapshotData a, XLogSnapshotData b) {
            int x1 = a.cnt;
            int x2 = b.cnt;
            if (x1 == x2) {
                return a.sum > b.sum ? -1 : 1;
            }
            return x1 > x2 ? -1 : 1;
        }
    }
}

