/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.model.XLogData;
import scouter.client.preferences.PManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.xlog.views.XLogSelectionView;
import scouter.client.xlog.views.XLogViewPainter;
import scouter.client.xlog.views.XLogZoomTimeView;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;

public class XLogViewMouse
implements MouseListener,
MouseMoveListener {
    public SelectAreaMode mode = null;
    public int x1 = -1;
    public int y1 = -1;
    public int x2 = -1;
    public int y2 = -1;
    private Canvas canvas;
    private LongKeyLinkedMap<XLogData> data;
    private String objType;
    XLogViewPainter viewPainter;
    long last_draw = System.currentTimeMillis();
    public String yyyymmdd;

    public XLogViewMouse(LongKeyLinkedMap<XLogData> data, Canvas canvas) {
        this.data = data;
        this.canvas = canvas;
    }

    public void setPainter(XLogViewPainter viewPainter) {
        this.viewPainter = viewPainter;
    }

    public void setObjType(String objType) {
        this.objType = objType;
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.y2 = -1;
        this.y1 = -1;
        this.x2 = -1;
        this.x1 = -1;
        if (this.viewPainter.onMouseDoubleClick(e.x, e.y)) {
            this.canvas.redraw();
        }
    }

    public void setNewYValue() {
        this.canvas.redraw();
    }

    public void mouseDown(MouseEvent e) {
        this.y2 = -1;
        this.y1 = -1;
        this.x2 = -1;
        this.x1 = -1;
        switch (e.button) {
            case 1: {
                if ((e.stateMask & 0x20000) != 0) {
                    this.mode = SelectAreaMode.ZOOM_AREA;
                    break;
                }
                this.mode = SelectAreaMode.LIST_XLOG;
                break;
            }
            default: {
                this.mode = null;
            }
        }
        if (this.mode != null) {
            this.x1 = e.x;
            this.y1 = e.y;
            if (this.viewPainter.onMouseClick(this.x1, this.y1)) {
                this.canvas.redraw();
            }
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.mode != null && this.x1 >= 0 && this.y1 >= 0) {
            this.x2 = e.x;
            this.y2 = e.y;
            long now = System.currentTimeMillis();
            if (now > this.last_draw + 50L) {
                this.last_draw = now;
                this.canvas.redraw();
            }
        } else {
            this.y2 = -1;
            this.y1 = -1;
            this.x2 = -1;
            this.x1 = -1;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.mode != null && this.x1 >= 0 && this.x2 >= 0 && this.y1 >= 0 && this.y2 >= 0) {
            switch (this.mode) {
                case LIST_XLOG: {
                    this.listSelectedXLog(e.display, this.x1, this.y1, this.x2, this.y2);
                    break;
                }
                case ZOOM_AREA: {
                    this.zoominArea(e.display, this.x1, this.y1, this.x2, this.y2);
                }
            }
        }
        this.y2 = -1;
        this.y1 = -1;
        this.x2 = -1;
        this.x1 = -1;
        this.canvas.redraw();
        this.mode = null;
    }

    public void listSelectedXLog(Display display, int x1, int y1, int x2, int y2) {
        int txCnt = 0;
        ArrayList<XLogData> selectedData = new ArrayList<XLogData>();
        Enumeration en = this.data.values();
        while (en.hasMoreElements()) {
            XLogData item = (XLogData)en.nextElement();
            if (!this.inRect(x1, y1, x2, y2, item.x, item.y) || !item.filter_ok) continue;
            ++txCnt;
            if (selectedData.size() >= PManager.getInstance().getInt("xlog_drag_max_count")) continue;
            selectedData.add(item);
        }
        if (txCnt < 1) {
            ConsoleProxy.info("[XLog] no xlogs in selected area.");
            return;
        }
        ConsoleProxy.info("[XLog] " + txCnt + " selected.");
        try {
            IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            XLogSelectionView view = (XLogSelectionView)win.getActivePage().showView(XLogSelectionView.ID, this.objType, 1);
            view.setInput(selectedData, this.objType, this.yyyymmdd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void zoominArea(final Display display, final int x1, final int y1, final int x2, final int y2) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                final LongKeyLinkedMap zoomData = new LongKeyLinkedMap();
                LongEnumer enumer = XLogViewMouse.this.data.keys();
                double max = 0.0;
                double min = Double.MAX_VALUE;
                while (enumer.hasMoreElements()) {
                    long key = enumer.nextLong();
                    XLogData item = (XLogData)XLogViewMouse.this.data.get(key);
                    if (!XLogViewMouse.this.inRect(x1, y1, x2, y2, item.x, item.y) || !item.filter_ok) continue;
                    switch (XLogViewMouse.this.viewPainter.yAxisMode) {
                        case ELAPSED: {
                            if ((double)item.p.elapsed / 1000.0 > max) {
                                max = (double)item.p.elapsed / 1000.0;
                            }
                            if (!((double)item.p.elapsed / 1000.0 < min)) break;
                            min = (double)item.p.elapsed / 1000.0;
                            break;
                        }
                        case CPU: {
                            if ((double)item.p.cpu > max) {
                                max = item.p.cpu;
                            }
                            if (!((double)item.p.cpu < min)) break;
                            min = item.p.cpu;
                            break;
                        }
                        case SQL_TIME: {
                            if ((double)item.p.sqlTime / 1000.0 > max) {
                                max = (double)item.p.sqlTime / 1000.0;
                            }
                            if (!((double)item.p.sqlTime / 1000.0 < min)) break;
                            min = (double)item.p.sqlTime / 1000.0;
                            break;
                        }
                        case SQL_COUNT: {
                            if ((double)item.p.sqlCount > max) {
                                max = item.p.sqlCount;
                            }
                            if (!((double)item.p.sqlCount < min)) break;
                            min = item.p.sqlCount;
                            break;
                        }
                        case APICALL_TIME: {
                            if ((double)item.p.apicallTime / 1000.0 > max) {
                                max = (double)item.p.apicallTime / 1000.0;
                            }
                            if (!((double)item.p.apicallTime / 1000.0 < min)) break;
                            min = (double)item.p.apicallTime / 1000.0;
                            break;
                        }
                        case APICALL_COUNT: {
                            if ((double)item.p.apicallCount > max) {
                                max = item.p.apicallCount;
                            }
                            if (!((double)item.p.apicallCount < min)) break;
                            min = item.p.apicallCount;
                            break;
                        }
                        case HEAP_USED: {
                            if ((double)item.p.kbytes > max) {
                                max = item.p.kbytes;
                            }
                            if (!((double)item.p.kbytes < min)) break;
                            min = item.p.kbytes;
                            break;
                        }
                        default: {
                            if ((double)item.p.elapsed / 1000.0 > max) {
                                max = (double)item.p.elapsed / 1000.0;
                            }
                            if (!((double)item.p.elapsed / 1000.0 < min)) break;
                            min = (double)item.p.elapsed / 1000.0;
                        }
                    }
                    zoomData.put(key, (Object)new XLogData(item.p, item.serverId));
                }
                if (zoomData.isEmpty()) {
                    return;
                }
                final long stime = ((XLogData)zoomData.getFirstValue()).p.endTime - 500L;
                final long etime = ((XLogData)zoomData.getLastValue()).p.endTime + 500L;
                final double yMax = max * 1.01;
                final double yMin = min * 0.99;
                ExUtil.exec(display, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConsoleProxy.info("[XLog] " + zoomData.size() + " selected.");
                            IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            XLogZoomTimeView view = (XLogZoomTimeView)win.getActivePage().showView(XLogZoomTimeView.ID, String.valueOf((this).XLogViewMouse.this.objType) + stime + etime + yMax + yMin, 1);
                            if (view != null) {
                                view.setInput(stime, etime, yMax, yMin, (LongKeyLinkedMap<XLogData>)zoomData, (this).XLogViewMouse.this.objType, (this).XLogViewMouse.this.viewPainter.yAxisMode);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        });
    }

    public boolean inRect(int x, int y, int tx, int ty, int sx, int sy) {
        if (x > tx) {
            int ttx = x;
            x = tx;
            tx = ttx;
        }
        if (y > ty) {
            int tty = y;
            y = ty;
            ty = tty;
        }
        return x < sx && y < sy && tx > sx && ty > sy;
    }

    static enum SelectAreaMode {
        LIST_XLOG,
        ZOOM_AREA;

    }
}

