/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Enumeration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.popup.XLogYValueMaxDialog;
import scouter.client.preferences.PManager;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.TimeUtil;
import scouter.client.xlog.ImageCache;
import scouter.client.xlog.XLogFilterStatus;
import scouter.client.xlog.XLogYAxisEnum;
import scouter.client.xlog.views.PointMap;
import scouter.client.xlog.views.XLogViewMouse;
import scouter.lang.pack.XLogPack;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.HashUtil;
import scouter.util.IPUtil;
import scouter.util.LongKeyLinkedMap;
import scouter.util.Pair;
import scouter.util.StrMatch;
import scouter.util.StringUtil;

public class XLogViewPainter {
    public static Color color_black = new Color(null, 0, 0, 0);
    public static Color color_white = new Color(null, 255, 255, 255);
    public static Color color_grid_narrow = new Color(null, 220, 228, 255);
    public static Color color_grid_wide = new Color(null, 200, 208, 255);
    public static Color color_blue = new Color(null, 0, 0, 255);
    public static Color color_red = new Color(null, 255, 0, 0);
    public static Color ignore_area = new Color(null, 234, 234, 234);
    public long xTimeRange;
    public long originalRange;
    private double yValueMax;
    private double yValueMin;
    private boolean viewIsInAdditionalDataLoading;
    public long lastDrawTimeStart;
    public long lastDrawTimeEnd;
    private XLogViewMouse mouse;
    private PointMap pointMap;
    private final LongKeyLinkedMap<XLogData> xLogPerfData;
    private ImageCache dotImage;
    public int selectedUrlHash;
    XLogFilterStatus filterStatus;
    public XLogYAxisEnum yAxisMode;
    private int filter_hash;
    public StrMatch objNameMat;
    public StrMatch serviceMat;
    public StrMatch ipMat;
    public Pair<Long, Long> startFromToMat;
    public Pair<Integer, Integer> resFromToMat;
    public StrMatch loginMat;
    public StrMatch descMat;
    public StrMatch text1Mat;
    public StrMatch text2Mat;
    public StrMatch text3Mat;
    public StrMatch text4Mat;
    public StrMatch text5Mat;
    public StrMatch userAgentMat;
    public String profileSizeExpr;
    public String profileByteExpr;
    public String txtHasDump;
    public String yyyymmdd;
    ITimeChange callback;
    int serverId;
    private long endTime;
    private Rectangle area;
    private Image ibuffer;
    boolean onGoing;
    private Object lock;
    int chart_x;
    long paintedEndTime;
    int mouseX;
    int mouseY;
    ObjectSelectManager objSelMgr;
    int count;
    public int moveWidth;
    private boolean zoomMode;
    private long zoomEndtime;
    private DateTimeFormatter hmsFormatter;

    public XLogViewPainter(LongKeyLinkedMap<XLogData> xLogPerfData, XLogViewMouse mouse, ITimeChange callback) {
        this.originalRange = this.xTimeRange = 300000L;
        this.yValueMin = 0.0;
        this.viewIsInAdditionalDataLoading = false;
        this.lastDrawTimeStart = 0L;
        this.lastDrawTimeEnd = 0L;
        this.pointMap = new PointMap();
        this.dotImage = ImageCache.getInstance();
        this.selectedUrlHash = 0;
        this.yAxisMode = XLogYAxisEnum.ELAPSED;
        this.filter_hash = 0;
        this.onGoing = false;
        this.lock = new Object();
        this.objSelMgr = ObjectSelectManager.getInstance();
        this.moveWidth = 0;
        this.zoomMode = false;
        this.hmsFormatter = DateTimeFormatter.ofPattern("HHmmss");
        this.mouse = mouse;
        this.xLogPerfData = xLogPerfData;
        this.callback = callback;
    }

    public void setEndTime(long etime) {
        this.endTime = etime;
        if (this.endTime <= 0L) {
            this.endTime = 0L;
        }
    }

    public void setTimeRange(long range) {
        this.originalRange = this.xTimeRange = range;
    }

    public void setViewIsInAdditionalDataLoading(boolean b) {
        this.viewIsInAdditionalDataLoading = b;
    }

    public long getTimeRange() {
        return this.xTimeRange;
    }

    public void setValueRange(double minValue, double maxValue) {
        this.yValueMin = minValue;
        this.yValueMax = maxValue;
    }

    public void dispose() {
        if (this.ibuffer != null) {
            this.ibuffer.dispose();
        }
    }

    public void set(Rectangle area) {
        this.area = area;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        if (this.area == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.onGoing) {
                return;
            }
            this.onGoing = true;
        }
        int work_w = this.area.width < 200 ? 200 : this.area.width;
        int work_h = this.area.height < 200 ? 200 : this.area.height;
        Image img = new Image(null, work_w, work_h);
        GC gc = new GC((Drawable)img);
        this.draw(gc, work_w, work_h);
        gc.dispose();
        Image old = this.ibuffer;
        this.ibuffer = img;
        if (old != null) {
            old.dispose();
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.onGoing = false;
        }
    }

    public long getLastTime() {
        return this.paintedEndTime;
    }

    private void draw(GC gc, int work_w, int work_h) {
        if (this.area == null) {
            return;
        }
        String maxLabel = FormatUtil.print((Object)new Double(this.yValueMax), (String)"#,##0.00");
        this.chart_x = maxLabel.length() * 6 + 30;
        int chart_y = 30;
        int chart_w = work_w - this.chart_x - 30;
        int chart_h = work_h - chart_y - 30;
        this.pointMap.reset(chart_w, chart_h);
        long time_end = (this.endTime > 0L ? this.endTime : TimeUtil.getCurrentTime(this.serverId)) + (long)this.moveWidth;
        long time_start = time_end - this.xTimeRange;
        if (this.zoomMode) {
            time_end = this.zoomEndtime + (long)this.moveWidth;
            time_start = time_end - this.xTimeRange;
        }
        this.paintedEndTime = time_end;
        gc.setForeground(color_black);
        if (this.filter_hash != new XLogFilterStatus().hashCode()) {
            gc.setBackground(ColorUtil.getInstance().getColor("azure"));
        } else {
            gc.setBackground(color_white);
        }
        gc.fillRectangle(0, 0, work_w, work_h);
        if (this.yAxisMode == XLogYAxisEnum.ELAPSED) {
            int ignoreMs = PManager.getInstance().getInt("xlog_ignore_time");
            if (this.yValueMin == 0.0 && ignoreMs > 0) {
                gc.setBackground(ignore_area);
                int chart_igreno_h = (int)((double)ignoreMs / (this.yValueMax * 1000.0) * (double)chart_h);
                if (chart_igreno_h > chart_h) {
                    chart_igreno_h = chart_h;
                }
                gc.fillRoundRectangle(this.chart_x, 30 + chart_h - chart_igreno_h, chart_w + 5, chart_igreno_h + 5, 1, 1);
                gc.setBackground(color_white);
            }
        }
        gc.setLineWidth(1);
        gc.setLineStyle(3);
        double valueRange = this.yValueMax - this.yValueMin;
        double yUnit = ChartUtil.getYaxisUnit(valueRange, chart_h);
        double yValue = 0.0;
        while (yValue <= valueRange) {
            int y = (int)((double)(chart_y + chart_h) - (double)chart_h * yValue / valueRange);
            gc.setForeground(color_grid_narrow);
            gc.drawLine(this.chart_x, y, this.chart_x + chart_w, y);
            String s = FormatUtil.print((Object)new Double(yValue + this.yValueMin), (String)"#,##0.00");
            gc.setForeground(color_black);
            gc.drawString(s, this.chart_x - (15 + s.length() * 6), y - 5);
            yValue += yUnit;
        }
        double xUnit = ChartUtil.getSplitTimeUnit(this.xTimeRange, chart_w);
        String xLabelFormat = ChartUtil.getTimeFormat((long)xUnit);
        long spareTime = time_end % (long)xUnit;
        int labelOnNum = (int)((double)time_end % (xUnit * 5.0) / xUnit);
        int xi = 0;
        double timeDelta = this.xTimeRange - spareTime;
        while (timeDelta > 0.0) {
            boolean labelOn;
            boolean bl = labelOn = xi++ % 5 == labelOnNum;
            if (labelOn) {
                gc.setForeground(color_grid_wide);
                gc.setLineStyle(1);
            } else {
                gc.setForeground(color_grid_narrow);
                gc.setLineStyle(3);
            }
            int x = (int)((double)this.chart_x + (double)chart_w * timeDelta / (double)this.xTimeRange);
            gc.drawLine(x, chart_y, x, chart_y + chart_h);
            if (labelOn) {
                gc.setForeground(color_black);
                String s = FormatUtil.print((Object)new Date(time_start + (long)timeDelta), (String)xLabelFormat);
                gc.drawString(s, x - 25, chart_y + chart_h + 5 + 5);
            }
            timeDelta -= xUnit;
        }
        this.lastDrawTimeStart = time_start;
        this.lastDrawTimeEnd = time_end;
        this.drawXPerfData(gc, time_start, time_end, this.chart_x, chart_y, chart_w, chart_h);
        this.drawChartBorder(gc, this.chart_x, chart_y, chart_w, chart_h);
        this.drawYaxisDescription(gc, this.chart_x, chart_y);
        this.drawTxCount(gc, this.chart_x, chart_w, chart_y);
        if (this.zoomMode) {
            this.drawZoomMode(gc, this.chart_x, chart_y, chart_w, time_start, time_end);
            this.drawZoomOut(gc, this.chart_x, chart_y, chart_w, chart_h);
        } else if (this.moveWidth != 0 || this.originalRange != this.xTimeRange) {
            this.drawCircle(gc, this.chart_x, chart_y, chart_w, chart_h);
        }
    }

    private void drawZoomMode(GC gc, int chart_x, int chart_y, int chart_w, long stime, long etime) {
        String cntText = "Zoom Mode(" + DateUtil.format((long)stime, (String)"HH:mm") + "~" + DateUtil.format((long)etime, (String)"HH:mm") + ")";
        gc.drawText(cntText, chart_x + chart_w - 140, chart_y - 20);
    }

    private void drawTxCount(GC gc, int chart_x, int chart_w, int chart_y) {
        gc.setFont(null);
        String cntText = " Count : " + FormatUtil.print((Object)new Long(this.count), (String)"#,##0");
        int strLen = gc.stringExtent((String)cntText).x;
        gc.drawText(cntText, chart_x + chart_w - strLen - 10, chart_y - 20);
    }

    private void drawYaxisDescription(GC gc, int chart_x, int chart_y) {
        gc.setFont(null);
        String desc = " " + this.yAxisMode.getDesc();
        gc.drawText(desc, chart_x, chart_y - 20);
    }

    private void drawChartBorder(GC gc, int chart_sx, int chart_sy, int chart_w, int chart_h) {
        gc.setLineStyle(1);
        gc.setLineWidth(1);
        gc.setForeground(color_black);
        gc.drawRoundRectangle(chart_sx, chart_sy, chart_w + 5, chart_h + 5, 1, 1);
    }

    public void drawImageBuffer(GC gc) {
        if (this.ibuffer != null) {
            gc.drawImage(this.ibuffer, 0, 0);
        }
    }

    public void drawSelectArea(GC gc) {
        if (this.mouse.x1 >= 0 && this.mouse.y1 >= 0 && this.mouse.x2 + this.mouse.y2 > 0) {
            Color color = null;
            switch (this.mouse.mode) {
                case LIST_XLOG: {
                    color = color_blue;
                    break;
                }
                case ZOOM_AREA: {
                    color = color_red;
                    break;
                }
            }
            if (color != null) {
                gc.setBackground(color);
                gc.setAlpha(15);
                gc.setLineStyle(1);
                gc.fillRectangle(this.mouse.x1, this.mouse.y1, this.mouse.x2 - this.mouse.x1, this.mouse.y2 - this.mouse.y1);
                gc.setAlpha(150);
                gc.setLineWidth(1);
                gc.setForeground(color);
                gc.drawRectangle(this.mouse.x1, this.mouse.y1, this.mouse.x2 - this.mouse.x1, this.mouse.y2 - this.mouse.y1);
            }
        }
    }

    public void drawCircle(GC gc, int chart_x, int chart_y, int chart_w, int chart_h) {
        this.mouseX = chart_x + chart_w + 5;
        this.mouseY = chart_h / 2 + chart_y - 16;
        gc.drawImage(Images.circle, this.mouseX, this.mouseY);
    }

    public void drawZoomOut(GC gc, int chart_x, int chart_y, int chart_w, int chart_h) {
        this.mouseX = chart_x + chart_w + 10;
        this.mouseY = chart_h / 2 + chart_y - 16;
        gc.drawImage(Images.zoomout, this.mouseX, this.mouseY);
    }

    public boolean onMouseDoubleClick(int x, int y) {
        boolean isChange = false;
        if (x < this.chart_x) {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            XLogYValueMaxDialog dialog = new XLogYValueMaxDialog(display, this);
            dialog.show();
            isChange = true;
        }
        return isChange;
    }

    private void initializeChart() {
        this.moveWidth = 0;
        this.xTimeRange = this.originalRange;
        this.load();
        this.zoomMode = false;
        this.build();
    }

    public boolean onMouseClick(int x, int y) {
        boolean isChange = false;
        if ((this.moveWidth != 0 || this.xTimeRange != this.originalRange) && x > this.mouseX && x < this.mouseX + 32 && y > this.mouseY && y < this.mouseY + 32) {
            this.initializeChart();
            isChange = true;
        }
        return isChange;
    }

    /*
     * Unable to fully structure code
     */
    private void removeOutsidePerfData(long time_start, long time_end) {
        if (!this.zoomMode) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.xLogPerfData.removeFirst();
lbl5:
            // 2 sources

            ** while (this.xLogPerfData.size() > 0 && ((XLogData)this.xLogPerfData.getFirstValue()).p.endTime < time_start)
        }
lbl6:
        // 1 sources

        if (this.endTime > 0L) {
            while (this.xLogPerfData.size() > 0 && ((XLogData)this.xLogPerfData.getLastValue()).p.endTime > time_end) {
                this.xLogPerfData.removeLast();
            }
        }
    }

    private void drawXPerfData(GC gc, long time_start, long time_end, int chart_x, int chart_y, int chart_w, int chart_h) {
        this.count = 0;
        if (this.xLogPerfData.size() == 0) {
            return;
        }
        if (!this.viewIsInAdditionalDataLoading) {
            this.removeOutsidePerfData(time_start - 10000L, time_end);
        }
        Enumeration en = this.xLogPerfData.values();
        while (en.hasMoreElements()) {
            XLogData d = (XLogData)en.nextElement();
            if (d == null || d.p.endTime < time_start || d.p.endTime > time_end) continue;
            if (d.filter_hash != this.filter_hash) {
                d.filter_ok = this.isFilterOk(d);
                d.filter_hash = this.filter_hash;
            }
            if (!d.filter_ok) continue;
            if (this.objSelMgr.isUnselectedObject(d.p.objHash)) {
                d.y = -1;
                d.x = -1;
                continue;
            }
            int x = (int)((long)chart_w * (d.p.endTime - time_start) / this.xTimeRange);
            d.x = chart_x + x;
            int y = 0;
            double value = 0.0;
            switch (this.yAxisMode) {
                case ELAPSED: {
                    if ((double)d.p.elapsed / 1000.0 >= this.yValueMax) {
                        value = -1.0;
                        break;
                    }
                    value = (double)d.p.elapsed / 1000.0;
                    break;
                }
                case CPU: {
                    if ((double)d.p.cpu >= this.yValueMax) {
                        value = -1.0;
                        break;
                    }
                    value = d.p.cpu;
                    break;
                }
                case SQL_TIME: {
                    if ((double)d.p.sqlTime / 1000.0 >= this.yValueMax) {
                        value = -1.0;
                        break;
                    }
                    value = (double)d.p.sqlTime / 1000.0;
                    break;
                }
                case SQL_COUNT: {
                    if ((double)d.p.sqlCount >= this.yValueMax) {
                        value = -1.0;
                        break;
                    }
                    value = d.p.sqlCount;
                    break;
                }
                case APICALL_TIME: {
                    if ((double)d.p.apicallTime / 1000.0 >= this.yValueMax) {
                        value = -1.0;
                        break;
                    }
                    value = (double)d.p.apicallTime / 1000.0;
                    break;
                }
                case APICALL_COUNT: {
                    if ((double)d.p.apicallCount >= this.yValueMax) {
                        value = -1.0;
                        break;
                    }
                    value = d.p.apicallCount;
                    break;
                }
                case HEAP_USED: {
                    if ((double)d.p.kbytes >= this.yValueMax) {
                        value = -1.0;
                        break;
                    }
                    value = d.p.kbytes;
                    break;
                }
                default: {
                    value = (double)d.p.elapsed / 1000.0 >= this.yValueMax ? -1.0 : (double)d.p.elapsed / 1000.0;
                }
            }
            y = value < 0.0 ? chart_h - 1 : (int)((double)chart_h * (value - this.yValueMin) / (this.yValueMax - this.yValueMin));
            d.y = chart_h + chart_y - y;
            if (this.pointMap.check(x, y)) {
                try {
                    if (d.p.error != 0) {
                        gc.drawImage(this.dotImage.getXPErrorImage(d.p.xType), d.x, d.y);
                    } else {
                        gc.drawImage(this.dotImage.getXPImage(d.p.objHash, d.p.xType), d.x, d.y);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++this.count;
        }
    }

    public double getYValue() {
        return this.yValueMax;
    }

    public void setYValueMaxValue(double max) {
        this.yValueMax = max;
        this.build();
        this.mouse.setNewYValue();
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case 0x1000001: {
                this.yValueMax += this.yValueMax >= 2.0 ? 1.0 : 0.1;
                break;
            }
            case 0x1000002: {
                this.yValueMax -= this.yValueMax >= 2.0 ? 1.0 : (this.yValueMax < 0.5 ? 0.05 : 0.1);
                if (!(this.yValueMax < 0.05)) break;
                this.yValueMax = 0.05;
                break;
            }
            case 45: 
            case 16777261: {
                this.xTimeRange += 60000L;
                this.load();
                break;
            }
            case 61: 
            case 16777259: {
                this.xTimeRange -= 60000L;
                if (this.xTimeRange >= 60000L) break;
                this.xTimeRange = 60000L;
                break;
            }
            case 0x1000003: {
                this.moveWidth = (int)((long)this.moveWidth - 10000L);
                this.load();
                break;
            }
            case 0x1000004: {
                this.moveWidth = (int)((long)this.moveWidth + 10000L);
                this.load();
            }
        }
    }

    public boolean zoomIn(long stime, long etime) {
        if (this.endTime < etime || this.endTime - this.xTimeRange > stime || etime < stime) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)("MaxRange is between " + DateUtil.format((long)(this.endTime - this.xTimeRange), (String)"HH:mm") + " and " + DateUtil.format((long)this.endTime, (String)"HH:mm")));
            return false;
        }
        this.zoomEndtime = etime;
        this.xTimeRange = etime - stime;
        this.moveWidth = 0;
        this.zoomMode = true;
        this.build();
        return true;
    }

    public void endZoom() {
        this.initializeChart();
    }

    public boolean isZoomMode() {
        return this.zoomMode;
    }

    public void setServerId(int serverId) {
        this.serverId = serverId;
    }

    private void load() {
        if (this.zoomMode) {
            return;
        }
        long time_current = TimeUtil.getCurrentTime(this.serverId);
        long time_end = (this.endTime > 0L ? this.endTime : time_current) + (long)this.moveWidth;
        long time_start = time_end - this.xTimeRange;
        if (time_end > time_current) {
            this.moveWidth = (int)((long)this.moveWidth - 10000L);
            return;
        }
        this.callback.timeRangeChanged(time_start, time_end);
    }

    public boolean isFilterOk(XLogData d) {
        return this.isObjNameFilterOk(d) && this.isServiceFilterOk(d) && this.isIpFilterOk(d.p) && this.isStartTimeFilterOk(d.p) && this.isResponseTimeFilterOk(d.p) && this.isLoginFilterOk(d) && this.isDescFilterOk(d) && this.isDumpYnOk(d) && this.isText1FilterOk(d) && this.isText2FilterOk(d) && this.isText3FilterOk(d) && this.isText4FilterOk(d) && this.isText5FilterOk(d) && this.isUserAgentFilterOk(d) && this.isErrorFilterOk(d.p) && this.isApicallFilterOk(d.p) && this.isSqlFilterOk(d.p) && this.isSyncOk(d.p) && this.isAsyncOk(d.p) && this.isProfileSizeFilterOk(d.p) && this.isProfileByteFilterOk(d.p);
    }

    public boolean isObjNameFilterOk(XLogData d) {
        if (StringUtil.isEmpty((String)this.filterStatus.objName)) {
            return true;
        }
        if (this.objNameMat.getComp() == StrMatch.COMP.EQU) {
            return d.p.objHash == HashUtil.hash((String)this.objNameMat.getPattern());
        }
        String objName = TextProxy.object.getLoadText(this.yyyymmdd, d.p.objHash, d.serverId);
        return this.objNameMat.include(objName);
    }

    public boolean isServiceFilterOk(XLogData d) {
        if (StringUtil.isEmpty((String)this.filterStatus.service)) {
            return true;
        }
        if (this.serviceMat.getComp() == StrMatch.COMP.EQU) {
            return d.p.service == HashUtil.hash((String)this.serviceMat.getPattern());
        }
        String serviceName = TextProxy.service.getLoadText(this.yyyymmdd, d.p.service, d.serverId);
        return this.serviceMat.include(serviceName);
    }

    public boolean isIpFilterOk(XLogPack p) {
        if (StringUtil.isEmpty((String)this.filterStatus.ip)) {
            return true;
        }
        String value = IPUtil.toString((byte[])p.ipaddr);
        return this.ipMat.include(value);
    }

    public boolean isStartTimeFilterOk(XLogPack p) {
        if (StringUtil.isEmpty((String)this.filterStatus.startHmsFrom) || StringUtil.isEmpty((String)this.filterStatus.startHmsTo)) {
            return true;
        }
        long start = p.endTime - (long)p.elapsed;
        return (Long)this.startFromToMat.getLeft() <= start && start <= (Long)this.startFromToMat.getRight();
    }

    public boolean isResponseTimeFilterOk(XLogPack p) {
        if (StringUtil.isEmpty((String)this.filterStatus.responseTimeFrom) || StringUtil.isEmpty((String)this.filterStatus.responseTimeTo)) {
            return true;
        }
        return (Integer)this.resFromToMat.getLeft() <= p.elapsed && p.elapsed <= (Integer)this.resFromToMat.getRight();
    }

    public boolean isLoginFilterOk(XLogData d) {
        if (StringUtil.isEmpty((String)this.filterStatus.login)) {
            return true;
        }
        if (this.loginMat.getComp() == StrMatch.COMP.EQU) {
            return d.p.login == HashUtil.hash((String)this.loginMat.getPattern());
        }
        String login = TextProxy.login.getLoadText(this.yyyymmdd, d.p.login, d.serverId);
        return this.loginMat.include(login);
    }

    public boolean isDescFilterOk(XLogData d) {
        if (StringUtil.isEmpty((String)this.filterStatus.desc)) {
            return true;
        }
        if (this.descMat.getComp() == StrMatch.COMP.EQU) {
            return d.p.desc == HashUtil.hash((String)this.descMat.getPattern());
        }
        String desc = TextProxy.desc.getLoadText(this.yyyymmdd, d.p.desc, d.serverId);
        return this.descMat.include(desc);
    }

    public boolean isDumpYnOk(XLogData d) {
        if (StringUtil.isEmpty((String)this.filterStatus.hasDumpYn)) {
            return true;
        }
        if (this.filterStatus.hasDumpYn.equals("Y")) {
            return d.p.hasDump == 1;
        }
        return d.p.hasDump == 0;
    }

    public boolean isText1FilterOk(XLogData d) {
        if (StringUtil.isEmpty((String)this.filterStatus.text1)) {
            return true;
        }
        return this.text1Mat.include(d.p.text1);
    }

    public boolean isText2FilterOk(XLogData d) {
        if (StringUtil.isEmpty((String)this.filterStatus.text2)) {
            return true;
        }
        return this.text2Mat.include(d.p.text2);
    }

    public boolean isText3FilterOk(XLogData d) {
        if (StringUtil.isEmpty((String)this.filterStatus.text3)) {
            return true;
        }
        return this.text3Mat.include(d.p.text3);
    }

    public boolean isText4FilterOk(XLogData d) {
        if (StringUtil.isEmpty((String)this.filterStatus.text4)) {
            return true;
        }
        return this.text4Mat.include(d.p.text4);
    }

    public boolean isText5FilterOk(XLogData d) {
        if (StringUtil.isEmpty((String)this.filterStatus.text5)) {
            return true;
        }
        return this.text5Mat.include(d.p.text5);
    }

    public boolean isUserAgentFilterOk(XLogData d) {
        if (StringUtil.isEmpty((String)this.filterStatus.userAgent)) {
            return true;
        }
        if (this.userAgentMat.getComp() == StrMatch.COMP.EQU) {
            return d.p.userAgent == HashUtil.hash((String)this.userAgentMat.getPattern());
        }
        String userAgent = TextProxy.userAgent.getLoadText(this.yyyymmdd, d.p.userAgent, d.serverId);
        return this.userAgentMat.include(userAgent);
    }

    public boolean isProfileSizeFilterOk(XLogPack p) {
        if (StringUtil.isEmpty((String)this.filterStatus.profileSizeText)) {
            return true;
        }
        String exp = this.filterStatus.profileSizeText.trim();
        char sign0 = exp.charAt(0);
        char sign1 = exp.length() >= 2 ? exp.charAt(1) : (char)'\u0000';
        try {
            if (sign0 == '>') {
                if (sign1 == '=') {
                    return p.profileCount >= Integer.parseInt(exp.substring(2));
                }
                return p.profileCount > Integer.parseInt(exp.substring(1));
            }
            if (sign0 == '<') {
                if (sign1 == '=') {
                    return p.profileCount <= Integer.parseInt(exp.substring(2));
                }
                return p.profileCount < Integer.parseInt(exp.substring(1));
            }
            if (sign0 == '=') {
                if (sign1 == '=') {
                    return p.profileCount == Integer.parseInt(exp.substring(2));
                }
                return p.profileCount == Integer.parseInt(exp.substring(1));
            }
            return p.profileCount == Integer.parseInt(exp);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return true;
        }
    }

    public boolean isProfileByteFilterOk(XLogPack p) {
        if (StringUtil.isEmpty((String)this.filterStatus.profileBytesText)) {
            return true;
        }
        String exp = this.filterStatus.profileBytesText.trim();
        char sign0 = exp.charAt(0);
        char sign1 = exp.length() >= 2 ? exp.charAt(1) : (char)'\u0000';
        try {
            if (sign0 == '>') {
                if (sign1 == '=') {
                    return p.profileSize >= Integer.parseInt(exp.substring(2));
                }
                return p.profileSize > Integer.parseInt(exp.substring(1));
            }
            if (sign0 == '<') {
                if (sign1 == '=') {
                    return p.profileSize <= Integer.parseInt(exp.substring(2));
                }
                return p.profileSize < Integer.parseInt(exp.substring(1));
            }
            if (sign0 == '=') {
                if (sign1 == '=') {
                    return p.profileSize == Integer.parseInt(exp.substring(2));
                }
                return p.profileSize == Integer.parseInt(exp.substring(1));
            }
            return p.profileSize == Integer.parseInt(exp);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return true;
        }
    }

    public boolean isErrorFilterOk(XLogPack p) {
        if (this.filterStatus.onlyError) {
            return p.error != 0;
        }
        return true;
    }

    public boolean isSqlFilterOk(XLogPack p) {
        if (this.filterStatus.onlySql) {
            return p.sqlCount > 0;
        }
        return true;
    }

    public boolean isSyncOk(XLogPack p) {
        if (this.filterStatus.onlySync) {
            return p.xType != 2 && p.xType != 3 && p.xType != 4;
        }
        return true;
    }

    public boolean isAsyncOk(XLogPack p) {
        if (this.filterStatus.onlyAsync) {
            return p.xType == 2 || p.xType == 3 || p.xType == 4;
        }
        return true;
    }

    public boolean isApicallFilterOk(XLogPack p) {
        if (this.filterStatus.onlyApicall) {
            return p.apicallCount > 0;
        }
        return true;
    }

    public void setYAxisMode(XLogYAxisEnum yAxis) {
        this.yAxisMode = yAxis;
        this.yValueMax = yAxis.getDefaultMax();
        this.yValueMin = 0.0;
    }

    public void setFilterStatus(XLogFilterStatus status) {
        this.filterStatus = status;
        this.filter_hash = this.filterStatus.hashCode();
        this.objNameMat = new StrMatch(status.objName);
        this.serviceMat = new StrMatch(status.service);
        this.ipMat = new StrMatch(status.ip);
        this.loginMat = new StrMatch(status.login);
        this.text1Mat = new StrMatch(status.text1);
        this.text2Mat = new StrMatch(status.text2);
        this.text3Mat = new StrMatch(status.text3);
        this.text4Mat = new StrMatch(status.text4);
        this.text5Mat = new StrMatch(status.text5);
        this.descMat = new StrMatch(status.desc);
        this.userAgentMat = new StrMatch(status.userAgent);
        this.txtHasDump = status.hasDumpYn;
        this.profileSizeExpr = status.profileSizeText;
        this.profileByteExpr = status.profileBytesText;
        if (status.startHmsFrom.length() >= 1 && status.startHmsTo.length() >= 1) {
            try {
                this.resFromToMat = new Pair((Object)Integer.parseInt(status.responseTimeFrom), (Object)Integer.parseInt(status.responseTimeTo));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (status.startHmsFrom.length() == 6 && status.startHmsTo.length() == 6) {
            long dateMillis = DateUtil.dateUnitToTimeMillis((long)DateUtil.getDateUnit((long)this.paintedEndTime));
            long startFrom = dateMillis + (long)(LocalTime.parse(status.startHmsFrom, this.hmsFormatter).toSecondOfDay() * 1000);
            long startTo = dateMillis + (long)(LocalTime.parse(status.startHmsTo, this.hmsFormatter).toSecondOfDay() * 1000);
            this.startFromToMat = new Pair((Object)startFrom, (Object)startTo);
        } else {
            this.startFromToMat = new Pair((Object)0L, (Object)0L);
        }
    }

    public static interface ITimeChange {
        public void timeRangeChanged(long var1, long var3);
    }
}

