/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.views;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import scouter.client.model.XLogData;
import scouter.client.util.ExUtil;
import scouter.client.xlog.XLogYAxisEnum;
import scouter.client.xlog.views.XLogViewCommon;
import scouter.util.DateUtil;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;

public class XLogZoomTimeView
extends XLogViewCommon {
    public static final String ID = XLogZoomTimeView.class.getName();

    public void createPartControl(Composite parent) {
        this.display = Display.getCurrent();
        this.shell = new Shell(this.display);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        this.create(parent, man);
        this.canvas.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                XLogZoomTimeView.this.viewPainter.set(XLogZoomTimeView.this.canvas.getClientArea());
                XLogZoomTimeView.this.viewPainter.build();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    @Override
    protected void openInExternalLink() {
    }

    @Override
    protected void clipboardOfExternalLink() {
    }

    public void refresh() {
        this.viewPainter.build();
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                XLogZoomTimeView.this.canvas.redraw();
            }
        });
    }

    public void setInput(long stime, long etime, double max, double min, LongKeyLinkedMap<XLogData> data, String objType, XLogYAxisEnum yAxisMode) {
        this.twdata.clear();
        this.objType = objType;
        LongEnumer enumer = data.keys();
        while (enumer.hasMoreElements()) {
            long key = enumer.nextLong();
            this.twdata.put(key, (Object)((XLogData)data.get(key)));
        }
        this.setObjType(objType);
        this.viewPainter.setYAxisMode(yAxisMode);
        this.viewPainter.setEndTime(etime);
        this.viewPainter.setTimeRange(etime - stime);
        this.viewPainter.setValueRange(min, max);
        this.setPartName("Zoom-in Area");
        this.setContentDescription(String.valueOf(DateUtil.format((long)stime, (String)"yyyy-MM-dd")) + "(" + DateUtil.format((long)stime, (String)"HH:mm:ss") + "~" + DateUtil.format((long)etime, (String)"HH:mm:ss") + ")");
        this.setDate(DateUtil.yyyymmdd((long)stime));
        this.refresh();
    }

    public void setInput(long stime, long etime, double max, double min, LongKeyLinkedMap<XLogData> data, String objType) {
        this.setInput(stime, etime, max, min, data, objType, XLogYAxisEnum.ELAPSED);
    }

    @Override
    public void setFocus() {
        super.setFocus();
        String statusMessage = "setInput(objType:" + this.objType + ", twdata size(): " + this.twdata.size() + ")";
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        slManager.setMessage(statusMessage);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void loadAdditinalData(long stime, long etime, boolean reverse) {
    }
}

