#! /bin/sh

SSHVER="openssh-9.6p1"
SSLVER="openssl-1.1.1w"

if [ -d /root/wellc-src ]; then
        LOGFILE=/root/wellc-src/install.log
else
        LOGFILE=/dev/null
fi

function proc_check {
        RCODE=`echo $?`
        if [ $RCODE -eq 1 ]; then
                exit 1
        fi
}

## CheckDir
if [ -d /usr/local/$SSLVER ]; then
	echo " $SSLVER is aleady installed "
	exit 1
fi

if [ -d /usr/local/$SSHVER ]; then
        echo " $SSHVER is aleady installed "
        exit 1
fi


yum install -y pam-devel zlib-devel openssl-devel gcc | tee -a $LOGFILE
proc_check

#cp /etc/ssh/sshd_config /root/wellc-src/sshd_config-backup
cp -rp /etc/ssh/ /root/wellc-src/ssh-backup
cp /etc/pam.d/sshd /root/wellc-src/pam-sshd-backup
cp /etc/init.d/sshd /root/wellc-src/init-sshd-backup

cd /root/wellc-src/

###########
# openssl #
###########
echo " > $SSLVER install start < " | tee -a $LOGFILE
tar zxvf $SSLVER.tar.gz
cd $SSLVER/

./config --prefix=/usr/local/$SSLVER | tee -a $LOGFILE
proc_check

make && make install | tee -a $LOGFILE
proc_check

OLD_SSL_FILE=`grep -nr openssl /etc/ld.so.conf* | grep -v "#" | awk -F: '{print $1}'`
OLD_SSL_NUM=`grep -nr openssl /etc/ld.so.conf* | grep -v "#" | awk -F: '{print $2}'`

if [ ! -z $OLD_SSL_NUM ]; then
        sed -i -e "$OLD_SSL_NUM"s:/:#/: $OLD_SSL_FILE | tee -a $LOGFILE
fi

echo " " >> /etc/ld.so.conf
echo "/usr/local/$SSLVER/lib" >> /etc/ld.so.conf
ldconfig | tee -a $LOGFILE
proc_check

/usr/local/$SSLVER/bin/openssl version | tee -a $LOGFILE

sleep 2
echo "  >  openssl installed <  " | tee -a $LOGFILE
sleep 2


###########
# openssh #
###########
echo " > $SSHVER install start < " | tee -a $LOGFILE
cd /root/wellc-src/

tar zxvf $SSHVER.tar.gz

cd $SSHVER/
./configure --prefix=/usr/local/$SSHVER --with-pam --with-ssl-dir=/usr/local/$SSLVER | tee -a $LOGFILE
proc_check

make && make install | tee -a $LOGFILE
proc_check

## Delete installed openssh
rpm -e --nodeps openssh openssh-clients openssh-server | tee -a $LOGFILE

ln -Tfs /usr/local/$SSHVER /usr/local/openssh | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/ssh /usr/bin/ssh | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/scp /usr/bin/scp | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/sftp /usr/bin/sftp | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/sbin/sshd /usr/sbin/sshd | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/ssh-add /usr/bin/ssh-add | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/ssh-agent /usr/bin/ssh-agent | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/ssh-keygen /usr/bin/ssh-keygen | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/ssh-keyscan /usr/bin/ssh-keyscan | tee -a $LOGFILE

rm -rf /etc/ssh
ln -Tfs /usr/local/openssh/etc /etc/ssh | tee -a $LOGFILE


# PAM Copy #
cp /root/wellc-src/pam-sshd-backup /etc/pam.d/sshd

# backup sshd_config Copy #
#cp /root/wellc-src/sshd_config-backup /etc/ssh/sshd_config
#c\p -p /root/wellc-src/ssh-backup/sshd_config /etc/ssh/sshd_config
c\p -p /root/wellc-src/ssh-backup/* /etc/ssh/

# init script Copy #
#cp /root/wellc-src/sshd.service /etc/systemd/system/
cp /root/wellc-src/init-sshd-backup /etc/init.d/sshd

# edit sshd_config #
sed -i -e s/^GSSAPIAuthentication/\#GSSAPIAuthentication/g /etc/ssh/sshd_config
sed -i -e s/^GSSAPICleanupCredentials/\#GSSAPICleanupCredentials/g /etc/ssh/sshd_config

service sshd start
chkconfig sshd on
service sshd status | tee -a $LOGFILE

echo " 변경하세요 "
echo "Subsystem       sftp    /usr/local/openssh/libexec/sftp-server"

