#! /bin/sh

SSHVER="openssh-9.6p1"

if [ -d /root/wellc-src ]; then
        LOGFILE=/root/wellc-src/install.log
else
        LOGFILE=/dev/null
fi

function proc_check {
        RCODE=`echo $?`
        if [ $RCODE -eq 1 ]; then
                exit 1
        fi
}

## CheckDir
if [ -d /usr/local/$SSLVER ]; then
        echo " $SSLVER is aleady installed "
        exit 1
fi

if [ -d /usr/local/$SSHVER ]; then
        echo " $SSHVER is aleady installed "
        exit 1
fi

yum install -y pam-devel zlib-devel openssl-devel gcc | tee -a $LOGFILE
proc_check

#cp /etc/ssh/sshd_config /root/wellc-src/sshd_config-backup
cp -rp /etc/ssh/ /root/wellc-src/ssh-backup
cp /etc/pam.d/sshd /root/wellc-src/pam-sshd-backup

cd /root/wellc-src/

###########
# openssh #
###########
cd /root/wellc-src/

tar zxvf $SSHVER.tar.gz

cd $SSHVER/
./configure --prefix=/usr/local/$SSHVER --with-pam | tee -a $LOGFILE
proc_check

make && make install | tee -a $LOGFILE
proc_check

## Delete installed openss
rpm -e --nodeps openssh openssh-clients openssh-server | tee -a $LOGFILE

ln -Tfs /usr/local/$SSHVER /usr/local/openssh | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/ssh /usr/bin/ssh | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/scp /usr/bin/scp | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/sftp /usr/bin/sftp | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/sbin/sshd /usr/sbin/sshd | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/ssh-add /usr/bin/ssh-add | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/ssh-agent /usr/bin/ssh-agent | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/ssh-keygen /usr/bin/ssh-keygen | tee -a $LOGFILE
ln -Tfs /usr/local/openssh/bin/ssh-keyscan /usr/bin/ssh-keyscan | tee -a $LOGFILE

rm -rf /etc/ssh
ln -Tfs /usr/local/openssh/etc /etc/ssh | tee -a $LOGFILE


# PAM Copy #
cp /root/wellc-src/pam-sshd-backup /etc/pam.d/sshd

# backup sshd_config Copy #
#cp /root/wellc-src/sshd_config-backup /etc/ssh/sshd_config
c\p -p /root/wellc-src/ssh-backup/sshd_config  /etc/ssh/sshd_config

# init script Copy #
cp /root/wellc-src/sshd.service /etc/systemd/system/

# edit sshd_config #
sed -i -e s/^GSSAPIAuthentication\ yes/\#GSSAPIAuthentication\ yes/g /etc/ssh/sshd_config
sed -i -e s/^GSSAPICleanupCredentials\ no/\#GSSAPICleanupCredentials\ no/g /etc/ssh/sshd_config

systemctl daemon-reload
systemctl start sshd
systemctl enable sshd
systemctl status sshd | tee -a $LOGFILE

echo " 변경하세요 "
echo "Subsystem       sftp    /usr/local/openssh/libexec/sftp-server"
