#!/bin/bash

# Create by pj at 24.01.25


## System Information
os="`cat /etc/system-release`"
osvercheck="`uname -r | cut -b 1`"
if [ $osvercheck -eq 5 ] ; then
	osver=9
elif [ $osvercheck -eq 4 ] ; then
        osver=8
elif [ $osvercheck -eq 3 ] ; then
        osver=7
elif [ $osvercheck -eq 2 ] ; then
        osver=6
else
        echo " Server OS kernel version is not certificated! "
        exit
fi

## date setting
DATE="`date +%Y_%m_%d`"

## Function list

#### openssh function start ####

## Define openssh version tar.gz file
	SSHVER=openssh-9.8p1
        OPENSSH=$SSHVER.tar.gz

## Check openssh install directory
        if [ -d /usr/local/openssh ]; then
                LINK=0  ### openssh link will not create
		if [ -L /usr/local/openssh ]; then
                        LINK=1
                fi
        else
                LINK=1  ### openssh link will be create
        fi

## Notification
        echo " $SSHVER will be start "
        sleep 3

## Check os version && Install openssh
        if [ $osver -eq 6 ]; then
		OLDVER=`ssh -V 2>&1 | cut -d , -f 1 | cut -d _ -f 2` &&
		OPENSSL=`grep -r ssl /etc/ld.so.conf* | grep -v "#" | awk -F: '{print $2}' | cut -d / -f 1-4` &&
                RDIR=/usr/local/src/openssh &&
		yum install -y wget openssl-devel expat-devel pam-devel gcc make gcc-c++ &&
		if [ ! -d $RDIR ]; then mkdir $RDIR; fi &&
		cd $RDIR &&
		cp -rp /usr/local/src/wellc-src/$OPENSSH $RDIR/
		if [ -d $RDIR/$SSHVER ]; then mv $RDIR/$SSHVER $RDIR/$SSHVER\_$DATE; fi &&
		tar zxvf $OPENSSH &&
		cd $SSHVER &&
		if [ -d /usr/local/$SSHVER ]; then mv /usr/local/$SSHVER /usr/local/$SSHVER\_$DATE; fi &&
		./configure --prefix=/usr/local/$SSHVER --with-pam --with-ssl-dir=$OPENSSL &&
		make -j $(nproc) &&
		make install &&
		cp -rp /etc/ssh/ $RDIR/ssh-backup-$OLDVER &&
		cp /etc/pam.d/sshd $RDIR/pam-sshd-backup-$OLDVER &&
		cp /etc/init.d/sshd $RDIR/init-sshd-backup-$OLDVER &&
		if [ `rpm -qa | grep openssh-server | wc -l` -eq 1 ]; then
			rpm -e --nodeps openssh openssh-clients openssh-server
		fi &&
		if [ $LINK -eq 1 ]; then
			ln -Tfs /usr/local/$SSHVER /usr/local/openssh &&
			ln -Tfs /usr/local/openssh/bin/ssh /usr/bin/ssh &&
			ln -Tfs /usr/local/openssh/bin/scp /usr/bin/scp &&
			ln -Tfs /usr/local/openssh/bin/sftp /usr/bin/sftp &&
			ln -Tfs /usr/local/openssh/sbin/sshd /usr/sbin/sshd &&
			ln -Tfs /usr/local/openssh/bin/ssh-add /usr/bin/ssh-add &&
			ln -Tfs /usr/local/openssh/bin/ssh-agent /usr/bin/ssh-agent &&
			ln -Tfs /usr/local/openssh/bin/ssh-keygen /usr/bin/ssh-keygen &&
			ln -Tfs /usr/local/openssh/bin/ssh-keyscan /usr/bin/ssh-keyscan &&
			rm -rf /etc/ssh &&
	                ln -Tfs /usr/local/openssh/etc /etc/ssh
		elif [ $LINK -eq 0 ]; then
                        ln -Tfs /usr/local/$SSHVER/bin/ssh /usr/bin/ssh &&
                        ln -Tfs /usr/local/$SSHVER/bin/scp /usr/bin/scp &&
                        ln -Tfs /usr/local/$SSHVER/bin/sftp /usr/bin/sftp &&
                        ln -Tfs /usr/local/$SSHVER/sbin/sshd /usr/sbin/sshd &&
                        ln -Tfs /usr/local/$SSHVER/bin/ssh-add /usr/bin/ssh-add &&
                        ln -Tfs /usr/local/$SSHVER/bin/ssh-agent /usr/bin/ssh-agent &&
                        ln -Tfs /usr/local/$SSHVER/bin/ssh-keygen /usr/bin/ssh-keygen &&
                        ln -Tfs /usr/local/$SSHVER/bin/ssh-keyscan /usr/bin/ssh-keyscan &&
			rm -rf /etc/ssh &&
	                ln -Tfs /usr/local/$SSHVER/etc /etc/ssh
		fi &&
		cp $RDIR/pam-sshd-backup-$OLDVER /etc/pam.d/sshd &&
		c\p -fp $RDIR/ssh-backup-$OLDVER/* /etc/ssh/ &&
		cp -rp $RDIR/init-sshd-backup-$OLDVER /etc/init.d/sshd &&
		sed -i -e s/^GSSAPIAuthentication/\#GSSAPIAuthentication/g /etc/ssh/sshd_config &&
		sed -i -e s/^GSSAPICleanupCredentials/\#GSSAPICleanupCredentials/g /etc/ssh/sshd_config &&
		sed -i -e s/Subsystem/\#Subsystem/g /etc/ssh/sshd_config &&
		sed -i -e "`grep -n ^#Subsystem /etc/ssh/sshd_config | awk -F: '{print $1}'` i\Subsystem       sftp    /usr/local/$SSHVER/libexec/sftp-server" /etc/ssh/sshd_config &&
		service sshd start &&
		chkconfig sshd on &&
		service sshd status
	elif [ $osver -ge 7 ] && [ $osver -le 9 ] ; then
		OLDVER=`ssh -V 2>&1 | cut -d , -f 1 | cut -d _ -f 2` &&
                OPENSSL=`grep -r ssl /etc/ld.so.conf* | grep -v "#" | awk -F: '{print $2}' | cut -d / -f 1-4` &&
                RDIR=/usr/local/src/openssh &&
		if [ $osver -eq 7 ]; then
			yum install -y wget openssl-devel expat-devel pam-devel gcc make gcc-c++ libedit-devel
		elif [ $osver -eq 8 ]; then
			dnf install -y wget openssl-devel expat-devel pam-devel gcc make gcc-c++ &&
			dnf install -y /usr/local/src/wellc-src/libedit-devel-3.1-23.20170329cvs.el8.x86_64.rpm
		elif [ $osver -eq 9 ]; then
			dnf install -y wget openssl-devel expat-devel pam-devel gcc make gcc-c++ libedit-devel
		fi &&
		if [ ! -d $RDIR ]; then mkdir $RDIR; fi &&
		cd $RDIR &&
		cp -rp /usr/local/src/wellc-src/$OPENSSH $RDIR/
		if [ -d $RDIR/$SSHVER ]; then mv $RDIR/$SSHVER $RDIR/$SSHVER\_$DATE; fi &&
		tar zxvf $OPENSSH &&
		cd $SSHVER &&
		if [ -d /usr/local/$SSHVER ]; then mv /usr/local/$SSHVER /usr/local/$SSHVER\_$DATE; fi &&
		./configure --prefix=/usr/local/$SSHVER --with-pam --with-ssl-dir=$OPENSSL --with-libedit &&
		make -j $(nproc) &&
		make install &&
		cp -rp /etc/ssh/ $RDIR/ssh-backup-$OLDVER &&
		cp /etc/pam.d/sshd $RDIR/pam-sshd-backup-$OLDVER &&
		if [ `rpm -qa | grep openssh-server | wc -l` -eq 1 ]; then
                        rpm -e --nodeps openssh openssh-clients openssh-server
                fi &&
		if [ $LINK -eq 1 ]; then
                        ln -Tfs /usr/local/$SSHVER /usr/local/openssh &&
                        ln -Tfs /usr/local/openssh/bin/ssh /usr/bin/ssh &&
                        ln -Tfs /usr/local/openssh/bin/scp /usr/bin/scp &&
                        ln -Tfs /usr/local/openssh/bin/sftp /usr/bin/sftp &&
                        ln -Tfs /usr/local/openssh/sbin/sshd /usr/sbin/sshd &&
                        ln -Tfs /usr/local/openssh/bin/ssh-add /usr/bin/ssh-add &&
                        ln -Tfs /usr/local/openssh/bin/ssh-agent /usr/bin/ssh-agent &&
                        ln -Tfs /usr/local/openssh/bin/ssh-keygen /usr/bin/ssh-keygen &&
                        ln -Tfs /usr/local/openssh/bin/ssh-keyscan /usr/bin/ssh-keyscan &&
                        rm -rf /etc/ssh &&
                        ln -Tfs /usr/local/openssh/etc /etc/ssh
                elif [ $LINK -eq 0 ]; then
                        ln -Tfs /usr/local/$SSHVER/bin/ssh /usr/bin/ssh &&
                        ln -Tfs /usr/local/$SSHVER/bin/scp /usr/bin/scp &&
                        ln -Tfs /usr/local/$SSHVER/bin/sftp /usr/bin/sftp &&
                        ln -Tfs /usr/local/$SSHVER/sbin/sshd /usr/sbin/sshd &&
                        ln -Tfs /usr/local/$SSHVER/bin/ssh-add /usr/bin/ssh-add &&
                        ln -Tfs /usr/local/$SSHVER/bin/ssh-agent /usr/bin/ssh-agent &&
                        ln -Tfs /usr/local/$SSHVER/bin/ssh-keygen /usr/bin/ssh-keygen &&
                        ln -Tfs /usr/local/$SSHVER/bin/ssh-keyscan /usr/bin/ssh-keyscan &&
                        rm -rf /etc/ssh &&
                        ln -Tfs /usr/local/$SSHVER/etc /etc/ssh
                fi &&
		cp $RDIR/pam-sshd-backup-$OLDVER /etc/pam.d/sshd &&
		c\p -fp $RDIR/ssh-backup-$OLDVER/sshd_config /etc/ssh/sshd_config &&
		echo "[Unit]
Description= SSH Server

[Service]
ExecStart=/usr/local/$SSHVER/sbin/sshd -D \$OPTIONS
ExecReload=/bin/kill -HUP \$MAINPID
KillMode=process
Restart=on-failure
RestartSec=10

[Install]
WantedBy=multi-user.target" > /usr/lib/systemd/system/sshd.service &&
		chmod 644 /usr/lib/systemd/system/sshd.service &&
		sed -i -e s/^GSSAPIAuthentication/\#GSSAPIAuthentication/g /etc/ssh/sshd_config &&
		sed -i -e s/^GSSAPICleanupCredentials/\#GSSAPICleanupCredentials/g /etc/ssh/sshd_config &&
		sed -i -e s/Subsystem/\#Subsystem/g /etc/ssh/sshd_config &&
		sed -i -e "`grep -n ^#Subsystem /etc/ssh/sshd_config | awk -F: '{print $1}'` i\Subsystem       sftp    /usr/local/$SSHVER/libexec/sftp-server" /etc/ssh/sshd_config &&
		systemctl daemon-reload &&
		systemctl start sshd &&
		systemctl enable sshd &&
		systemctl status sshd
	fi

