#!/bin/bash

blue="\033[40;34;1m"
red="\033[40;31;1m"
green="\033[40;32;1m"
white="\033[40;37;0m"
white_red="\033[41;37;1m"
yellow="\033[40;33;1m"
yellow_blue="\033[44;33;1m"

INST_DIR=/root/wellc-zabbix
LOG_FILE=$INST_DIR/zabbix_install.log
ORG_DIR=/usr/share/zabbix
IP_AD=`hostname -I|cut -f1 -d ' '`

## Install httpd-2.4.37 mysql-8.0.36 zabbix-7.0LTS
echo "Install httpd-2.4.37 mysql-8.0.36 zabbix-7.0LTS Start" | tee -a $LOG_FILE &&
echo "zabbix installing ..." | tee -a $LOG_FILE &&
dnf install mysql-server -y &&
rpm -Uvh https://repo.zabbix.com/zabbix/7.0/rocky/8/x86_64/zabbix-release-7.0-2.el8.noarch.rpm &&
dnf clean all &&
sed -i 's/gpgcheck=1/gpgcheck=0/g' /etc/yum.repos.d/zabbix.repo &&
dnf module switch-to php:8.0 -y &&
dnf install zabbix-server-mysql zabbix-web-mysql zabbix-apache-conf zabbix-sql-scripts zabbix-selinux-policy zabbix-agent -y 

### Mysql config
echo -n "Please enter mysql root password : "
read DB_PW
echo "mysql root password : $DB_PW" | tee -a $LOG_FILE 

echo -n "Please enter mysql zabbix password : "
read AE_PW
echo "mysql zabbix password : $AE_PW" | tee -a $LOG_FILE &&
echo "** mysql -uzabbix -p'$AE_PW'" >> $LOG_FILE &&

echo "mysql service start" | tee -a $LOG_FILE &&
systemctl start mysqld &&

echo "mysql configuring ..." | tee -a $LOG_FILE &&
mysqladmin -uroot password "$DB_PW" >/dev/null 2>&1 &&
echo "alter user 'root'@'localhost' identified by '$DB_PW';" | mysql -uroot -p"$DB_PW"  >/dev/null 2>&1 &&

echo "zabbix database creating ..." | tee -a $LOG_FILE &&
echo "create database zabbix character set utf8mb4 collate utf8mb4_bin;" | mysql -uroot -p"$DB_PW" >/dev/null 2>&1 &&
echo "create user zabbix@localhost identified by '$AE_PW';" | mysql -uroot -p"$DB_PW"  >/dev/null 2>&1 &&
echo "grant all privileges on zabbix.* to zabbix@localhost;" | mysql -uroot -p"$DB_PW" >/dev/null 2>&1 &&
echo "set global log_bin_trust_function_creators = 1;" | mysql -uroot -p"$DB_PW"  >/dev/null 2>&1 &&
zcat /usr/share/zabbix-sql-scripts/mysql/server.sql.gz | mysql -uzabbix -p"$AE_PW" zabbix >/dev/null 2>&1 &&
echo "set global log_bin_trust_function_creators = 0;" | mysql -uroot -p"$DB_PW" >/dev/null 2>&1 &&

## ADAMO-EMS DBPassword Input
echo "zabbix configuring ..." | tee -a $LOG_FILE &&
sed -i "s/DBPassword\=/DBPassword\=\nDBPassword\=$AE_PW/g" /etc/zabbix/zabbix_server.conf &&

## ADAMO-EMS service start & enable
echo "zabbix service start" &&
systemctl restart zabbix-server zabbix-agent httpd php-fpm >/dev/null 2>&1 &&
systemctl enable zabbix-server zabbix-agent httpd php-fpm >/dev/null 2>&1 &&

## Install 한글 font
echo "한글 font installing ..." | tee -a $LOG_FILE &&
rm /etc/alternatives/zabbix-web-font &&
mkdir -p /usr/share/fonts/NanumFont &&
cd /usr/share/fonts/NanumFont &&
unzip $INST_DIR/NanumFont_TTF_ALL.zip >/dev/null 2>&1 &&
ln -s /usr/share/fonts/NanumFont/NanumGothic.ttf /etc/alternatives/zabbix-web-font &&

systemctl restart zabbix-server zabbix-agent httpd php-fpm >/dev/null 2>&1 &&

echo "Install httpd-2.4.37 mysql-8.0.32 zabbix-7.0LTS Finish" | tee -a $LOG_FILE &&
echo "Please Enter $IP_AD/zabbix" |tee -a $LOG_FILE
